/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateGroupCursorDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="time")
    private final Date time;
    @JsonProperty(value="groupName")
    private final String groupName;
    @JsonProperty(value="instanceName")
    private final String instanceName;
    @JsonProperty(value="timeoutInMs")
    private final Integer timeoutInMs;
    @JsonProperty(value="commitOnGet")
    private final Boolean commitOnGet;

    @Deprecated
    @ConstructorProperties(value={"type", "time", "groupName", "instanceName", "timeoutInMs", "commitOnGet"})
    public CreateGroupCursorDetails(Type type, Date time, String groupName, String instanceName, Integer timeoutInMs, Boolean commitOnGet) {
        this.type = type;
        this.time = time;
        this.groupName = groupName;
        this.instanceName = instanceName;
        this.timeoutInMs = timeoutInMs;
        this.commitOnGet = commitOnGet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Type getType() {
        return this.type;
    }

    public Date getTime() {
        return this.time;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Integer getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public Boolean getCommitOnGet() {
        return this.commitOnGet;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateGroupCursorDetails(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf((Object)this.type));
        sb.append(", time=").append(String.valueOf(this.time));
        sb.append(", groupName=").append(String.valueOf(this.groupName));
        sb.append(", instanceName=").append(String.valueOf(this.instanceName));
        sb.append(", timeoutInMs=").append(String.valueOf(this.timeoutInMs));
        sb.append(", commitOnGet=").append(String.valueOf(this.commitOnGet));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateGroupCursorDetails)) {
            return false;
        }
        CreateGroupCursorDetails other = (CreateGroupCursorDetails)((Object)o);
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.time, other.time) && Objects.equals(this.groupName, other.groupName) && Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.timeoutInMs, other.timeoutInMs) && Objects.equals(this.commitOnGet, other.commitOnGet) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.time == null ? 43 : this.time.hashCode());
        result = result * 59 + (this.groupName == null ? 43 : this.groupName.hashCode());
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + (this.timeoutInMs == null ? 43 : this.timeoutInMs.hashCode());
        result = result * 59 + (this.commitOnGet == null ? 43 : this.commitOnGet.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type {
        AtTime("AT_TIME"),
        Latest("LATEST"),
        TrimHorizon("TRIM_HORIZON");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="time")
        private Date time;
        @JsonProperty(value="groupName")
        private String groupName;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="timeoutInMs")
        private Integer timeoutInMs;
        @JsonProperty(value="commitOnGet")
        private Boolean commitOnGet;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder time(Date time) {
            this.time = time;
            this.__explicitlySet__.add("time");
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            this.__explicitlySet__.add("groupName");
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public Builder timeoutInMs(Integer timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            this.__explicitlySet__.add("timeoutInMs");
            return this;
        }

        public Builder commitOnGet(Boolean commitOnGet) {
            this.commitOnGet = commitOnGet;
            this.__explicitlySet__.add("commitOnGet");
            return this;
        }

        public CreateGroupCursorDetails build() {
            CreateGroupCursorDetails model = new CreateGroupCursorDetails(this.type, this.time, this.groupName, this.instanceName, this.timeoutInMs, this.commitOnGet);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateGroupCursorDetails model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("time")) {
                this.time(model.getTime());
            }
            if (model.wasPropertyExplicitlySet("groupName")) {
                this.groupName(model.getGroupName());
            }
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            if (model.wasPropertyExplicitlySet("timeoutInMs")) {
                this.timeoutInMs(model.getTimeoutInMs());
            }
            if (model.wasPropertyExplicitlySet("commitOnGet")) {
                this.commitOnGet(model.getCommitOnGet());
            }
            return this;
        }
    }
}

