/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.streaming.model.PartitionReservation;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Group
extends ExplicitlySetBmcModel {
    @JsonProperty(value="streamId")
    private final String streamId;
    @JsonProperty(value="groupName")
    private final String groupName;
    @JsonProperty(value="reservations")
    private final List<PartitionReservation> reservations;

    @Deprecated
    @ConstructorProperties(value={"streamId", "groupName", "reservations"})
    public Group(String streamId, String groupName, List<PartitionReservation> reservations) {
        this.streamId = streamId;
        this.groupName = groupName;
        this.reservations = reservations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<PartitionReservation> getReservations() {
        return this.reservations;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Group(");
        sb.append("super=").append(super.toString());
        sb.append("streamId=").append(String.valueOf(this.streamId));
        sb.append(", groupName=").append(String.valueOf(this.groupName));
        sb.append(", reservations=").append(String.valueOf(this.reservations));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)((Object)o);
        return Objects.equals(this.streamId, other.streamId) && Objects.equals(this.groupName, other.groupName) && Objects.equals(this.reservations, other.reservations) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.groupName == null ? 43 : this.groupName.hashCode());
        result = result * 59 + (this.reservations == null ? 43 : this.reservations.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="streamId")
        private String streamId;
        @JsonProperty(value="groupName")
        private String groupName;
        @JsonProperty(value="reservations")
        private List<PartitionReservation> reservations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            this.__explicitlySet__.add("streamId");
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            this.__explicitlySet__.add("groupName");
            return this;
        }

        public Builder reservations(List<PartitionReservation> reservations) {
            this.reservations = reservations;
            this.__explicitlySet__.add("reservations");
            return this;
        }

        public Group build() {
            Group model = new Group(this.streamId, this.groupName, this.reservations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Group model) {
            if (model.wasPropertyExplicitlySet("streamId")) {
                this.streamId(model.getStreamId());
            }
            if (model.wasPropertyExplicitlySet("groupName")) {
                this.groupName(model.getGroupName());
            }
            if (model.wasPropertyExplicitlySet("reservations")) {
                this.reservations(model.getReservations());
            }
            return this;
        }
    }
}

