/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Message
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stream")
    private final String stream;
    @JsonProperty(value="partition")
    private final String partition;
    @JsonProperty(value="key")
    private final byte[] key;
    @JsonProperty(value="value")
    private final byte[] value;
    @JsonProperty(value="offset")
    private final Long offset;
    @JsonProperty(value="timestamp")
    private final Date timestamp;

    @Deprecated
    @ConstructorProperties(value={"stream", "partition", "key", "value", "offset", "timestamp"})
    public Message(String stream, String partition, byte[] key, byte[] value, Long offset, Date timestamp) {
        this.stream = stream;
        this.partition = partition;
        this.key = key;
        this.value = value;
        this.offset = offset;
        this.timestamp = timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStream() {
        return this.stream;
    }

    public String getPartition() {
        return this.partition;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Message(");
        sb.append("super=").append(super.toString());
        sb.append("stream=").append(String.valueOf(this.stream));
        sb.append(", partition=").append(String.valueOf(this.partition));
        sb.append(", key=").append(includeByteArrayContents ? Arrays.toString(this.key) : String.valueOf(this.key) + (this.key != null ? " (byte[" + this.key.length + "])" : ""));
        sb.append(", value=").append(includeByteArrayContents ? Arrays.toString(this.value) : String.valueOf(this.value) + (this.value != null ? " (byte[" + this.value.length + "])" : ""));
        sb.append(", offset=").append(String.valueOf(this.offset));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)((Object)o);
        return Objects.equals(this.stream, other.stream) && Objects.equals(this.partition, other.partition) && Arrays.equals(this.key, other.key) && Arrays.equals(this.value, other.value) && Objects.equals(this.offset, other.offset) && Objects.equals(this.timestamp, other.timestamp) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stream == null ? 43 : this.stream.hashCode());
        result = result * 59 + (this.partition == null ? 43 : this.partition.hashCode());
        result = result * 59 + Arrays.hashCode(this.key);
        result = result * 59 + Arrays.hashCode(this.value);
        result = result * 59 + (this.offset == null ? 43 : this.offset.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stream")
        private String stream;
        @JsonProperty(value="partition")
        private String partition;
        @JsonProperty(value="key")
        private byte[] key;
        @JsonProperty(value="value")
        private byte[] value;
        @JsonProperty(value="offset")
        private Long offset;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stream(String stream) {
            this.stream = stream;
            this.__explicitlySet__.add("stream");
            return this;
        }

        public Builder partition(String partition) {
            this.partition = partition;
            this.__explicitlySet__.add("partition");
            return this;
        }

        public Builder key(byte[] key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder value(byte[] value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder offset(Long offset) {
            this.offset = offset;
            this.__explicitlySet__.add("offset");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Message build() {
            Message model = new Message(this.stream, this.partition, this.key, this.value, this.offset, this.timestamp);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Message model) {
            if (model.wasPropertyExplicitlySet("stream")) {
                this.stream(model.getStream());
            }
            if (model.wasPropertyExplicitlySet("partition")) {
                this.partition(model.getPartition());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("offset")) {
                this.offset(model.getOffset());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            return this;
        }
    }
}

