/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.streaming.model.CustomEncryptionKeyDetails;
import com.oracle.bmc.streaming.model.KafkaSettings;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateStreamPoolDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="kafkaSettings")
    private final KafkaSettings kafkaSettings;
    @JsonProperty(value="customEncryptionKeyDetails")
    private final CustomEncryptionKeyDetails customEncryptionKeyDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"name", "kafkaSettings", "customEncryptionKeyDetails", "freeformTags", "definedTags"})
    public UpdateStreamPoolDetails(String name, KafkaSettings kafkaSettings, CustomEncryptionKeyDetails customEncryptionKeyDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.name = name;
        this.kafkaSettings = kafkaSettings;
        this.customEncryptionKeyDetails = customEncryptionKeyDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public KafkaSettings getKafkaSettings() {
        return this.kafkaSettings;
    }

    public CustomEncryptionKeyDetails getCustomEncryptionKeyDetails() {
        return this.customEncryptionKeyDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateStreamPoolDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", kafkaSettings=").append(String.valueOf((Object)this.kafkaSettings));
        sb.append(", customEncryptionKeyDetails=").append(String.valueOf((Object)this.customEncryptionKeyDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateStreamPoolDetails)) {
            return false;
        }
        UpdateStreamPoolDetails other = (UpdateStreamPoolDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.kafkaSettings, (Object)other.kafkaSettings) && Objects.equals((Object)this.customEncryptionKeyDetails, (Object)other.customEncryptionKeyDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.kafkaSettings == null ? 43 : this.kafkaSettings.hashCode());
        result = result * 59 + (this.customEncryptionKeyDetails == null ? 43 : this.customEncryptionKeyDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="kafkaSettings")
        private KafkaSettings kafkaSettings;
        @JsonProperty(value="customEncryptionKeyDetails")
        private CustomEncryptionKeyDetails customEncryptionKeyDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder kafkaSettings(KafkaSettings kafkaSettings) {
            this.kafkaSettings = kafkaSettings;
            this.__explicitlySet__.add("kafkaSettings");
            return this;
        }

        public Builder customEncryptionKeyDetails(CustomEncryptionKeyDetails customEncryptionKeyDetails) {
            this.customEncryptionKeyDetails = customEncryptionKeyDetails;
            this.__explicitlySet__.add("customEncryptionKeyDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateStreamPoolDetails build() {
            UpdateStreamPoolDetails model = new UpdateStreamPoolDetails(this.name, this.kafkaSettings, this.customEncryptionKeyDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateStreamPoolDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("kafkaSettings")) {
                this.kafkaSettings(model.getKafkaSettings());
            }
            if (model.wasPropertyExplicitlySet("customEncryptionKeyDetails")) {
                this.customEncryptionKeyDetails(model.getCustomEncryptionKeyDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

