/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.PutMessagesDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class PutMessagesRequest
extends BmcRequest<PutMessagesDetails> {
    private String streamId;
    private PutMessagesDetails putMessagesDetails;
    private String opcRequestId;

    public String getStreamId() {
        return this.streamId;
    }

    public PutMessagesDetails getPutMessagesDetails() {
        return this.putMessagesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PutMessagesDetails getBody$() {
        return this.putMessagesDetails;
    }

    public Builder toBuilder() {
        return new Builder().streamId(this.streamId).putMessagesDetails(this.putMessagesDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamId=").append(String.valueOf(this.streamId));
        sb.append(",putMessagesDetails=").append(String.valueOf((Object)this.putMessagesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutMessagesRequest)) {
            return false;
        }
        PutMessagesRequest other = (PutMessagesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamId, other.streamId) && Objects.equals((Object)this.putMessagesDetails, (Object)other.putMessagesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.putMessagesDetails == null ? 43 : this.putMessagesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PutMessagesRequest, PutMessagesDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamId = null;
        private PutMessagesDetails putMessagesDetails = null;
        private String opcRequestId = null;

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder putMessagesDetails(PutMessagesDetails putMessagesDetails) {
            this.putMessagesDetails = putMessagesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutMessagesRequest o) {
            this.streamId(o.getStreamId());
            this.putMessagesDetails(o.getPutMessagesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutMessagesRequest build() {
            PutMessagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PutMessagesDetails body) {
            this.putMessagesDetails(body);
            return this;
        }

        public PutMessagesRequest buildWithoutInvocationCallback() {
            PutMessagesRequest request = new PutMessagesRequest();
            request.streamId = this.streamId;
            request.putMessagesDetails = this.putMessagesDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

