/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.streaming.model.Message;
import com.oracle.bmc.streaming.requests.GetMessagesRequest;
import com.oracle.bmc.streaming.responses.GetMessagesResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMessagesConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(GetMessagesConverter.class);

    public static GetMessagesRequest interceptRequest(GetMessagesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetMessagesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCursor(), (String)"cursor is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180418").path("streams").path(HttpUtils.encodePathSegment((String)request.getStreamId())).path("messages");
        target = target.queryParam("cursor", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCursor())});
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetMessagesResponse> fromResponse() {
        return GetMessagesConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, GetMessagesResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, GetMessagesResponse> transformer = new Function<Response, GetMessagesResponse>(){

            @Override
            public GetMessagesResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.streaming.responses.GetMessagesResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<Message>>(){}, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<Message>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetMessagesResponse.Builder builder = GetMessagesResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.items((List)response.getItem());
                Optional opcNextCursorHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-next-cursor");
                if (opcNextCursorHeader.isPresent()) {
                    builder.opcNextCursor((String)HeaderUtils.toValue((String)"opc-next-cursor", (String)((String)((List)opcNextCursorHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetMessagesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

