/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CustomEncryptionKey
extends ExplicitlySetBmcModel {
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="keyState")
    private final KeyState keyState;

    @Deprecated
    @ConstructorProperties(value={"kmsKeyId", "keyState"})
    public CustomEncryptionKey(String kmsKeyId, KeyState keyState) {
        this.kmsKeyId = kmsKeyId;
        this.keyState = keyState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public KeyState getKeyState() {
        return this.keyState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomEncryptionKey(");
        sb.append("super=").append(super.toString());
        sb.append("kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", keyState=").append(String.valueOf((Object)this.keyState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomEncryptionKey)) {
            return false;
        }
        CustomEncryptionKey other = (CustomEncryptionKey)((Object)o);
        return Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals((Object)this.keyState, (Object)other.keyState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.keyState == null ? 43 : this.keyState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum KeyState {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleting("DELETING"),
        None("NONE"),
        Failed("FAILED"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, KeyState> map;

        private KeyState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static KeyState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'KeyState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(KeyState.class);
            map = new HashMap<String, KeyState>();
            for (KeyState v : KeyState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="keyState")
        private KeyState keyState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder keyState(KeyState keyState) {
            this.keyState = keyState;
            this.__explicitlySet__.add("keyState");
            return this;
        }

        public CustomEncryptionKey build() {
            CustomEncryptionKey model = new CustomEncryptionKey(this.kmsKeyId, this.keyState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomEncryptionKey model) {
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("keyState")) {
                this.keyState(model.getKeyState());
            }
            return this;
        }
    }
}

