/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KafkaSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bootstrapServers")
    private final String bootstrapServers;
    @JsonProperty(value="autoCreateTopicsEnable")
    private final Boolean autoCreateTopicsEnable;
    @JsonProperty(value="logRetentionHours")
    private final Integer logRetentionHours;
    @JsonProperty(value="numPartitions")
    private final Integer numPartitions;

    @Deprecated
    @ConstructorProperties(value={"bootstrapServers", "autoCreateTopicsEnable", "logRetentionHours", "numPartitions"})
    public KafkaSettings(String bootstrapServers, Boolean autoCreateTopicsEnable, Integer logRetentionHours, Integer numPartitions) {
        this.bootstrapServers = bootstrapServers;
        this.autoCreateTopicsEnable = autoCreateTopicsEnable;
        this.logRetentionHours = logRetentionHours;
        this.numPartitions = numPartitions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public Boolean getAutoCreateTopicsEnable() {
        return this.autoCreateTopicsEnable;
    }

    public Integer getLogRetentionHours() {
        return this.logRetentionHours;
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KafkaSettings(");
        sb.append("super=").append(super.toString());
        sb.append("bootstrapServers=").append(String.valueOf(this.bootstrapServers));
        sb.append(", autoCreateTopicsEnable=").append(String.valueOf(this.autoCreateTopicsEnable));
        sb.append(", logRetentionHours=").append(String.valueOf(this.logRetentionHours));
        sb.append(", numPartitions=").append(String.valueOf(this.numPartitions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaSettings)) {
            return false;
        }
        KafkaSettings other = (KafkaSettings)((Object)o);
        return Objects.equals(this.bootstrapServers, other.bootstrapServers) && Objects.equals(this.autoCreateTopicsEnable, other.autoCreateTopicsEnable) && Objects.equals(this.logRetentionHours, other.logRetentionHours) && Objects.equals(this.numPartitions, other.numPartitions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bootstrapServers == null ? 43 : this.bootstrapServers.hashCode());
        result = result * 59 + (this.autoCreateTopicsEnable == null ? 43 : this.autoCreateTopicsEnable.hashCode());
        result = result * 59 + (this.logRetentionHours == null ? 43 : this.logRetentionHours.hashCode());
        result = result * 59 + (this.numPartitions == null ? 43 : this.numPartitions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bootstrapServers")
        private String bootstrapServers;
        @JsonProperty(value="autoCreateTopicsEnable")
        private Boolean autoCreateTopicsEnable;
        @JsonProperty(value="logRetentionHours")
        private Integer logRetentionHours;
        @JsonProperty(value="numPartitions")
        private Integer numPartitions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            this.__explicitlySet__.add("bootstrapServers");
            return this;
        }

        public Builder autoCreateTopicsEnable(Boolean autoCreateTopicsEnable) {
            this.autoCreateTopicsEnable = autoCreateTopicsEnable;
            this.__explicitlySet__.add("autoCreateTopicsEnable");
            return this;
        }

        public Builder logRetentionHours(Integer logRetentionHours) {
            this.logRetentionHours = logRetentionHours;
            this.__explicitlySet__.add("logRetentionHours");
            return this;
        }

        public Builder numPartitions(Integer numPartitions) {
            this.numPartitions = numPartitions;
            this.__explicitlySet__.add("numPartitions");
            return this;
        }

        public KafkaSettings build() {
            KafkaSettings model = new KafkaSettings(this.bootstrapServers, this.autoCreateTopicsEnable, this.logRetentionHours, this.numPartitions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KafkaSettings model) {
            if (model.wasPropertyExplicitlySet("bootstrapServers")) {
                this.bootstrapServers(model.getBootstrapServers());
            }
            if (model.wasPropertyExplicitlySet("autoCreateTopicsEnable")) {
                this.autoCreateTopicsEnable(model.getAutoCreateTopicsEnable());
            }
            if (model.wasPropertyExplicitlySet("logRetentionHours")) {
                this.logRetentionHours(model.getLogRetentionHours());
            }
            if (model.wasPropertyExplicitlySet("numPartitions")) {
                this.numPartitions(model.getNumPartitions());
            }
            return this;
        }
    }
}

