/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAdminAsync;
import com.oracle.bmc.streaming.internal.http.ChangeConnectHarnessCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.ChangeStreamCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.ChangeStreamPoolCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.CreateConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.DeleteConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.GetConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.ListConnectHarnessesConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamPoolsConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamsConverter;
import com.oracle.bmc.streaming.internal.http.UpdateConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamPoolConverter;
import com.oracle.bmc.streaming.requests.ChangeConnectHarnessCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamPoolCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.CreateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamPoolRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.GetStreamPoolRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListConnectHarnessesRequest;
import com.oracle.bmc.streaming.requests.ListStreamPoolsRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.UpdateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeConnectHarnessCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamPoolCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.CreateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamPoolResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.GetStreamPoolResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListConnectHarnessesResponse;
import com.oracle.bmc.streaming.responses.ListStreamPoolsResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.UpdateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import com.oracle.bmc.util.RealmSpecificEndpointTemplateUtils;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAdminAsyncClient
implements StreamAdminAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAMADMIN").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(StreamAdminAsyncClient.class);
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private String regionId;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.clientConfigurationToUse = configuration;
        this.refreshClient();
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.regionId = provider.getRegion().getRegionId();
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    RestClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        this.regionId = region.getRegionId();
        Optional endpoint = GuavaUtils.adaptFromGuava((com.google.common.base.Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        this.regionId = regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public synchronized void useRealmSpecificEndpointTemplate(boolean useOfRealmSpecificEndpointTemplateEnabled) {
        this.setEndpoint(RealmSpecificEndpointTemplateUtils.getRealmSpecificEndpointTemplate((boolean)useOfRealmSpecificEndpointTemplateEnabled, (String)this.regionId, (Service)SERVICE));
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeConnectHarnessCompartmentResponse> changeConnectHarnessCompartment(ChangeConnectHarnessCompartmentRequest request, AsyncHandler<ChangeConnectHarnessCompartmentRequest, ChangeConnectHarnessCompartmentResponse> handler) {
        LOG.trace("Called async changeConnectHarnessCompartment");
        ChangeConnectHarnessCompartmentRequest interceptedRequest = ChangeConnectHarnessCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeConnectHarnessCompartmentConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ChangeConnectHarnessCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/ChangeConnectHarnessCompartment");
        Function<Response, ChangeConnectHarnessCompartmentResponse> transformer = ChangeConnectHarnessCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ChangeConnectHarnessCompartmentRequest, ChangeConnectHarnessCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeConnectHarnessCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeConnectHarnessCompartmentRequest, ChangeConnectHarnessCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeStreamCompartmentResponse> changeStreamCompartment(ChangeStreamCompartmentRequest request, AsyncHandler<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> handler) {
        LOG.trace("Called async changeStreamCompartment");
        ChangeStreamCompartmentRequest interceptedRequest = ChangeStreamCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamCompartmentConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ChangeStreamCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/ChangeStreamCompartment");
        Function<Response, ChangeStreamCompartmentResponse> transformer = ChangeStreamCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeStreamCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeStreamPoolCompartmentResponse> changeStreamPoolCompartment(ChangeStreamPoolCompartmentRequest request, AsyncHandler<ChangeStreamPoolCompartmentRequest, ChangeStreamPoolCompartmentResponse> handler) {
        LOG.trace("Called async changeStreamPoolCompartment");
        ChangeStreamPoolCompartmentRequest interceptedRequest = ChangeStreamPoolCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamPoolCompartmentConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ChangeStreamPoolCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/ChangeStreamPoolCompartment");
        Function<Response, ChangeStreamPoolCompartmentResponse> transformer = ChangeStreamPoolCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ChangeStreamPoolCompartmentRequest, ChangeStreamPoolCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeStreamPoolCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeStreamPoolCompartmentRequest, ChangeStreamPoolCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateConnectHarnessResponse> createConnectHarness(CreateConnectHarnessRequest request, AsyncHandler<CreateConnectHarnessRequest, CreateConnectHarnessResponse> handler) {
        LOG.trace("Called async createConnectHarness");
        CreateConnectHarnessRequest interceptedRequest = CreateConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "CreateConnectHarness", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/CreateConnectHarness");
        Function<Response, CreateConnectHarnessResponse> transformer = CreateConnectHarnessConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<CreateConnectHarnessRequest, CreateConnectHarnessResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateConnectHarnessDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateConnectHarnessRequest, CreateConnectHarnessResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateStreamResponse> createStream(CreateStreamRequest request, AsyncHandler<CreateStreamRequest, CreateStreamResponse> handler) {
        LOG.trace("Called async createStream");
        CreateStreamRequest interceptedRequest = CreateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "CreateStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/CreateStream");
        Function<Response, CreateStreamResponse> transformer = CreateStreamConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<CreateStreamRequest, CreateStreamResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateStreamDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateStreamRequest, CreateStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateStreamPoolResponse> createStreamPool(CreateStreamPoolRequest request, AsyncHandler<CreateStreamPoolRequest, CreateStreamPoolResponse> handler) {
        LOG.trace("Called async createStreamPool");
        CreateStreamPoolRequest interceptedRequest = CreateStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "CreateStreamPool", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/CreateStreamPool");
        Function<Response, CreateStreamPoolResponse> transformer = CreateStreamPoolConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<CreateStreamPoolRequest, CreateStreamPoolResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateStreamPoolDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateStreamPoolRequest, CreateStreamPoolResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteConnectHarnessResponse> deleteConnectHarness(DeleteConnectHarnessRequest request, AsyncHandler<DeleteConnectHarnessRequest, DeleteConnectHarnessResponse> handler) {
        LOG.trace("Called async deleteConnectHarness");
        DeleteConnectHarnessRequest interceptedRequest = DeleteConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "DeleteConnectHarness", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/DeleteConnectHarness");
        Function<Response, DeleteConnectHarnessResponse> transformer = DeleteConnectHarnessConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DeleteConnectHarnessRequest, DeleteConnectHarnessResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteConnectHarnessRequest, DeleteConnectHarnessResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteStreamResponse> deleteStream(DeleteStreamRequest request, AsyncHandler<DeleteStreamRequest, DeleteStreamResponse> handler) {
        LOG.trace("Called async deleteStream");
        DeleteStreamRequest interceptedRequest = DeleteStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "DeleteStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/DeleteStream");
        Function<Response, DeleteStreamResponse> transformer = DeleteStreamConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DeleteStreamRequest, DeleteStreamResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteStreamRequest, DeleteStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteStreamPoolResponse> deleteStreamPool(DeleteStreamPoolRequest request, AsyncHandler<DeleteStreamPoolRequest, DeleteStreamPoolResponse> handler) {
        LOG.trace("Called async deleteStreamPool");
        DeleteStreamPoolRequest interceptedRequest = DeleteStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "DeleteStreamPool", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/DeleteStreamPool");
        Function<Response, DeleteStreamPoolResponse> transformer = DeleteStreamPoolConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DeleteStreamPoolRequest, DeleteStreamPoolResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteStreamPoolRequest, DeleteStreamPoolResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConnectHarnessResponse> getConnectHarness(GetConnectHarnessRequest request, AsyncHandler<GetConnectHarnessRequest, GetConnectHarnessResponse> handler) {
        LOG.trace("Called async getConnectHarness");
        GetConnectHarnessRequest interceptedRequest = GetConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "GetConnectHarness", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/GetConnectHarness");
        Function<Response, GetConnectHarnessResponse> transformer = GetConnectHarnessConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetConnectHarnessRequest, GetConnectHarnessResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConnectHarnessRequest, GetConnectHarnessResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStreamResponse> getStream(GetStreamRequest request, AsyncHandler<GetStreamRequest, GetStreamResponse> handler) {
        LOG.trace("Called async getStream");
        GetStreamRequest interceptedRequest = GetStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "GetStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/GetStream");
        Function<Response, GetStreamResponse> transformer = GetStreamConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetStreamRequest, GetStreamResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStreamRequest, GetStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStreamPoolResponse> getStreamPool(GetStreamPoolRequest request, AsyncHandler<GetStreamPoolRequest, GetStreamPoolResponse> handler) {
        LOG.trace("Called async getStreamPool");
        GetStreamPoolRequest interceptedRequest = GetStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "GetStreamPool", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool");
        Function<Response, GetStreamPoolResponse> transformer = GetStreamPoolConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetStreamPoolRequest, GetStreamPoolResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStreamPoolRequest, GetStreamPoolResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConnectHarnessesResponse> listConnectHarnesses(ListConnectHarnessesRequest request, AsyncHandler<ListConnectHarnessesRequest, ListConnectHarnessesResponse> handler) {
        LOG.trace("Called async listConnectHarnesses");
        ListConnectHarnessesRequest interceptedRequest = ListConnectHarnessesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectHarnessesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ListConnectHarnesses", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarnessSummary/ListConnectHarnesses");
        Function<Response, ListConnectHarnessesResponse> transformer = ListConnectHarnessesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListConnectHarnessesRequest, ListConnectHarnessesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConnectHarnessesRequest, ListConnectHarnessesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListStreamPoolsResponse> listStreamPools(ListStreamPoolsRequest request, AsyncHandler<ListStreamPoolsRequest, ListStreamPoolsResponse> handler) {
        LOG.trace("Called async listStreamPools");
        ListStreamPoolsRequest interceptedRequest = ListStreamPoolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamPoolsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ListStreamPools", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPoolSummary/ListStreamPools");
        Function<Response, ListStreamPoolsResponse> transformer = ListStreamPoolsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListStreamPoolsRequest, ListStreamPoolsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListStreamPoolsRequest, ListStreamPoolsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListStreamsResponse> listStreams(ListStreamsRequest request, AsyncHandler<ListStreamsRequest, ListStreamsResponse> handler) {
        LOG.trace("Called async listStreams");
        ListStreamsRequest interceptedRequest = ListStreamsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ListStreams", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamSummary/ListStreams");
        Function<Response, ListStreamsResponse> transformer = ListStreamsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListStreamsRequest, ListStreamsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListStreamsRequest, ListStreamsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateConnectHarnessResponse> updateConnectHarness(UpdateConnectHarnessRequest request, AsyncHandler<UpdateConnectHarnessRequest, UpdateConnectHarnessResponse> handler) {
        LOG.trace("Called async updateConnectHarness");
        UpdateConnectHarnessRequest interceptedRequest = UpdateConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "UpdateConnectHarness", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/UpdateConnectHarness");
        Function<Response, UpdateConnectHarnessResponse> transformer = UpdateConnectHarnessConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UpdateConnectHarnessRequest, UpdateConnectHarnessResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateConnectHarnessDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateConnectHarnessRequest, UpdateConnectHarnessResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateStreamResponse> updateStream(UpdateStreamRequest request, AsyncHandler<UpdateStreamRequest, UpdateStreamResponse> handler) {
        LOG.trace("Called async updateStream");
        UpdateStreamRequest interceptedRequest = UpdateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "UpdateStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/UpdateStream");
        Function<Response, UpdateStreamResponse> transformer = UpdateStreamConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UpdateStreamRequest, UpdateStreamResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateStreamDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateStreamRequest, UpdateStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateStreamPoolResponse> updateStreamPool(UpdateStreamPoolRequest request, AsyncHandler<UpdateStreamPoolRequest, UpdateStreamPoolResponse> handler) {
        LOG.trace("Called async updateStreamPool");
        UpdateStreamPoolRequest interceptedRequest = UpdateStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "UpdateStreamPool", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/UpdateStreamPool");
        Function<Response, UpdateStreamPoolResponse> transformer = UpdateStreamPoolConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UpdateStreamPoolRequest, UpdateStreamPoolResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateStreamPoolDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateStreamPoolRequest, UpdateStreamPoolResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAdminAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public StreamAdminAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new StreamAdminAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

