/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAsync;
import com.oracle.bmc.streaming.StreamAsyncClientBuilder;
import com.oracle.bmc.streaming.internal.http.ConsumerCommitConverter;
import com.oracle.bmc.streaming.internal.http.ConsumerHeartbeatConverter;
import com.oracle.bmc.streaming.internal.http.CreateCursorConverter;
import com.oracle.bmc.streaming.internal.http.CreateGroupCursorConverter;
import com.oracle.bmc.streaming.internal.http.GetGroupConverter;
import com.oracle.bmc.streaming.internal.http.GetMessagesConverter;
import com.oracle.bmc.streaming.internal.http.PutMessagesConverter;
import com.oracle.bmc.streaming.internal.http.UpdateGroupConverter;
import com.oracle.bmc.streaming.requests.ConsumerCommitRequest;
import com.oracle.bmc.streaming.requests.ConsumerHeartbeatRequest;
import com.oracle.bmc.streaming.requests.CreateCursorRequest;
import com.oracle.bmc.streaming.requests.CreateGroupCursorRequest;
import com.oracle.bmc.streaming.requests.GetGroupRequest;
import com.oracle.bmc.streaming.requests.GetMessagesRequest;
import com.oracle.bmc.streaming.requests.PutMessagesRequest;
import com.oracle.bmc.streaming.requests.UpdateGroupRequest;
import com.oracle.bmc.streaming.responses.ConsumerCommitResponse;
import com.oracle.bmc.streaming.responses.ConsumerHeartbeatResponse;
import com.oracle.bmc.streaming.responses.CreateCursorResponse;
import com.oracle.bmc.streaming.responses.CreateGroupCursorResponse;
import com.oracle.bmc.streaming.responses.GetGroupResponse;
import com.oracle.bmc.streaming.responses.GetMessagesResponse;
import com.oracle.bmc.streaming.responses.PutMessagesResponse;
import com.oracle.bmc.streaming.responses.UpdateGroupResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAsyncClient
implements StreamAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAM").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(StreamAsyncClient.class);
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private String regionId;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    public StreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public StreamAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.clientConfigurationToUse = configuration;
        this.refreshClient();
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static StreamAsyncClientBuilder builder() {
        return new StreamAsyncClientBuilder(SERVICE);
    }

    RestClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ConsumerCommitResponse> consumerCommit(ConsumerCommitRequest request, AsyncHandler<ConsumerCommitRequest, ConsumerCommitResponse> handler) {
        LOG.trace("Called async consumerCommit");
        ConsumerCommitRequest interceptedRequest = ConsumerCommitConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ConsumerCommitConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "ConsumerCommit", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/ConsumerCommit");
        Function<Response, ConsumerCommitResponse> transformer = ConsumerCommitConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ConsumerCommitRequest, ConsumerCommitResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ConsumerCommitRequest, ConsumerCommitResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ConsumerHeartbeatResponse> consumerHeartbeat(ConsumerHeartbeatRequest request, AsyncHandler<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse> handler) {
        LOG.trace("Called async consumerHeartbeat");
        ConsumerHeartbeatRequest interceptedRequest = ConsumerHeartbeatConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ConsumerHeartbeatConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "ConsumerHeartbeat", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/ConsumerHeartbeat");
        Function<Response, ConsumerHeartbeatResponse> transformer = ConsumerHeartbeatConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ConsumerHeartbeatRequest, ConsumerHeartbeatResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCursorResponse> createCursor(CreateCursorRequest request, AsyncHandler<CreateCursorRequest, CreateCursorResponse> handler) {
        LOG.trace("Called async createCursor");
        CreateCursorRequest interceptedRequest = CreateCursorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCursorConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "CreateCursor", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Cursor/CreateCursor");
        Function<Response, CreateCursorResponse> transformer = CreateCursorConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<CreateCursorRequest, CreateCursorResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateCursorDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCursorRequest, CreateCursorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateGroupCursorResponse> createGroupCursor(CreateGroupCursorRequest request, AsyncHandler<CreateGroupCursorRequest, CreateGroupCursorResponse> handler) {
        LOG.trace("Called async createGroupCursor");
        CreateGroupCursorRequest interceptedRequest = CreateGroupCursorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateGroupCursorConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "CreateGroupCursor", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Cursor/CreateGroupCursor");
        Function<Response, CreateGroupCursorResponse> transformer = CreateGroupCursorConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<CreateGroupCursorRequest, CreateGroupCursorResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateGroupCursorDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateGroupCursorRequest, CreateGroupCursorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetGroupResponse> getGroup(GetGroupRequest request, AsyncHandler<GetGroupRequest, GetGroupResponse> handler) {
        LOG.trace("Called async getGroup");
        GetGroupRequest interceptedRequest = GetGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetGroupConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "GetGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/GetGroup");
        Function<Response, GetGroupResponse> transformer = GetGroupConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetGroupRequest, GetGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetGroupRequest, GetGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetMessagesResponse> getMessages(GetMessagesRequest request, AsyncHandler<GetMessagesRequest, GetMessagesResponse> handler) {
        LOG.trace("Called async getMessages");
        GetMessagesRequest interceptedRequest = GetMessagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMessagesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "GetMessages", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Message/GetMessages");
        Function<Response, GetMessagesResponse> transformer = GetMessagesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetMessagesRequest, GetMessagesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetMessagesRequest, GetMessagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PutMessagesResponse> putMessages(PutMessagesRequest request, AsyncHandler<PutMessagesRequest, PutMessagesResponse> handler) {
        LOG.trace("Called async putMessages");
        PutMessagesRequest interceptedRequest = PutMessagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutMessagesConverter.fromRequest(this.client, interceptedRequest);
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "PutMessages", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Message/PutMessages");
        Function<Response, PutMessagesResponse> transformer = PutMessagesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<PutMessagesRequest, PutMessagesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getPutMessagesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PutMessagesRequest, PutMessagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateGroupResponse> updateGroup(UpdateGroupRequest request, AsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handler) {
        LOG.trace("Called async updateGroup");
        UpdateGroupRequest interceptedRequest = UpdateGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateGroupConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "UpdateGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/UpdateGroup");
        Function<Response, UpdateGroupResponse> transformer = UpdateGroupConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateGroupDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateGroupRequest, UpdateGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }
}

