/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.streaming.Stream;
import com.oracle.bmc.streaming.StreamClientBuilder;
import com.oracle.bmc.streaming.internal.http.ConsumerCommitConverter;
import com.oracle.bmc.streaming.internal.http.ConsumerHeartbeatConverter;
import com.oracle.bmc.streaming.internal.http.CreateCursorConverter;
import com.oracle.bmc.streaming.internal.http.CreateGroupCursorConverter;
import com.oracle.bmc.streaming.internal.http.GetGroupConverter;
import com.oracle.bmc.streaming.internal.http.GetMessagesConverter;
import com.oracle.bmc.streaming.internal.http.PutMessagesConverter;
import com.oracle.bmc.streaming.internal.http.UpdateGroupConverter;
import com.oracle.bmc.streaming.requests.ConsumerCommitRequest;
import com.oracle.bmc.streaming.requests.ConsumerHeartbeatRequest;
import com.oracle.bmc.streaming.requests.CreateCursorRequest;
import com.oracle.bmc.streaming.requests.CreateGroupCursorRequest;
import com.oracle.bmc.streaming.requests.GetGroupRequest;
import com.oracle.bmc.streaming.requests.GetMessagesRequest;
import com.oracle.bmc.streaming.requests.PutMessagesRequest;
import com.oracle.bmc.streaming.requests.UpdateGroupRequest;
import com.oracle.bmc.streaming.responses.ConsumerCommitResponse;
import com.oracle.bmc.streaming.responses.ConsumerHeartbeatResponse;
import com.oracle.bmc.streaming.responses.CreateCursorResponse;
import com.oracle.bmc.streaming.responses.CreateGroupCursorResponse;
import com.oracle.bmc.streaming.responses.GetGroupResponse;
import com.oracle.bmc.streaming.responses.GetMessagesResponse;
import com.oracle.bmc.streaming.responses.PutMessagesResponse;
import com.oracle.bmc.streaming.responses.UpdateGroupResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamClient
implements Stream {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAM").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(StreamClient.class);
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private final CircuitBreakerConfiguration circuitBreakerConfiguration;
    private String regionId;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    RestClient getClient() {
        return this.client;
    }

    public StreamClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    protected StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        CircuitBreakerConfiguration userCircuitBreakerConfiguration;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.retryConfiguration = this.clientConfigurationToUse.getRetryConfiguration();
        this.circuitBreakerConfiguration = userCircuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        this.refreshClient();
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static StreamClientBuilder builder() {
        return new StreamClientBuilder(SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient, null, this.circuitBreakerConfiguration);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ConsumerCommitResponse consumerCommit(ConsumerCommitRequest request) {
        LOG.trace("Called consumerCommit");
        ConsumerCommitRequest interceptedRequest = ConsumerCommitConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ConsumerCommitConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "ConsumerCommit", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/ConsumerCommit");
        Function<Response, ConsumerCommitResponse> transformer = ConsumerCommitConverter.fromResponse(Optional.of(serviceDetails));
        return (ConsumerCommitResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ConsumerCommitResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ConsumerCommitResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ConsumerHeartbeatResponse consumerHeartbeat(ConsumerHeartbeatRequest request) {
        LOG.trace("Called consumerHeartbeat");
        ConsumerHeartbeatRequest interceptedRequest = ConsumerHeartbeatConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ConsumerHeartbeatConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "ConsumerHeartbeat", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/ConsumerHeartbeat");
        Function<Response, ConsumerHeartbeatResponse> transformer = ConsumerHeartbeatConverter.fromResponse(Optional.of(serviceDetails));
        return (ConsumerHeartbeatResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ConsumerHeartbeatResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ConsumerHeartbeatResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateCursorResponse createCursor(CreateCursorRequest request) {
        LOG.trace("Called createCursor");
        CreateCursorRequest interceptedRequest = CreateCursorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCursorConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "CreateCursor", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Cursor/CreateCursor");
        Function<Response, CreateCursorResponse> transformer = CreateCursorConverter.fromResponse(Optional.of(serviceDetails));
        return (CreateCursorResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCursorResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCursorDetails(), (BmcRequest)retriedRequest);
                return (CreateCursorResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateGroupCursorResponse createGroupCursor(CreateGroupCursorRequest request) {
        LOG.trace("Called createGroupCursor");
        CreateGroupCursorRequest interceptedRequest = CreateGroupCursorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateGroupCursorConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "CreateGroupCursor", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Cursor/CreateGroupCursor");
        Function<Response, CreateGroupCursorResponse> transformer = CreateGroupCursorConverter.fromResponse(Optional.of(serviceDetails));
        return (CreateGroupCursorResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateGroupCursorResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateGroupCursorDetails(), (BmcRequest)retriedRequest);
                return (CreateGroupCursorResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetGroupResponse getGroup(GetGroupRequest request) {
        LOG.trace("Called getGroup");
        GetGroupRequest interceptedRequest = GetGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "GetGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/GetGroup");
        Function<Response, GetGroupResponse> transformer = GetGroupConverter.fromResponse(Optional.of(serviceDetails));
        return (GetGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetGroupResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetMessagesResponse getMessages(GetMessagesRequest request) {
        LOG.trace("Called getMessages");
        GetMessagesRequest interceptedRequest = GetMessagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMessagesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "GetMessages", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Message/GetMessages");
        Function<Response, GetMessagesResponse> transformer = GetMessagesConverter.fromResponse(Optional.of(serviceDetails));
        return (GetMessagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetMessagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetMessagesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public PutMessagesResponse putMessages(PutMessagesRequest request) {
        LOG.trace("Called putMessages");
        PutMessagesRequest interceptedRequest = PutMessagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutMessagesConverter.fromRequest(this.client, interceptedRequest);
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "PutMessages", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Message/PutMessages");
        Function<Response, PutMessagesResponse> transformer = PutMessagesConverter.fromResponse(Optional.of(serviceDetails));
        return (PutMessagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PutMessagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getPutMessagesDetails(), (BmcRequest)retriedRequest);
                return (PutMessagesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest request) {
        LOG.trace("Called updateGroup");
        UpdateGroupRequest interceptedRequest = UpdateGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Stream", "UpdateGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/UpdateGroup");
        Function<Response, UpdateGroupResponse> transformer = UpdateGroupConverter.fromResponse(Optional.of(serviceDetails));
        return (UpdateGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateGroupResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }
}

