/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateCursorDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="partition")
    private final String partition;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="offset")
    private final Long offset;
    @JsonProperty(value="time")
    private final Date time;

    @Deprecated
    @ConstructorProperties(value={"partition", "type", "offset", "time"})
    public CreateCursorDetails(String partition, Type type, Long offset, Date time) {
        this.partition = partition;
        this.type = type;
        this.offset = offset;
        this.time = time;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPartition() {
        return this.partition;
    }

    public Type getType() {
        return this.type;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Date getTime() {
        return this.time;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateCursorDetails(");
        sb.append("super=").append(super.toString());
        sb.append("partition=").append(String.valueOf(this.partition));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", offset=").append(String.valueOf(this.offset));
        sb.append(", time=").append(String.valueOf(this.time));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCursorDetails)) {
            return false;
        }
        CreateCursorDetails other = (CreateCursorDetails)((Object)o);
        return Objects.equals(this.partition, other.partition) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.offset, other.offset) && Objects.equals(this.time, other.time) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.partition == null ? 43 : this.partition.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.offset == null ? 43 : this.offset.hashCode());
        result = result * 59 + (this.time == null ? 43 : this.time.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type {
        AfterOffset("AFTER_OFFSET"),
        AtOffset("AT_OFFSET"),
        AtTime("AT_TIME"),
        Latest("LATEST"),
        TrimHorizon("TRIM_HORIZON");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="partition")
        private String partition;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="offset")
        private Long offset;
        @JsonProperty(value="time")
        private Date time;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder partition(String partition) {
            this.partition = partition;
            this.__explicitlySet__.add("partition");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder offset(Long offset) {
            this.offset = offset;
            this.__explicitlySet__.add("offset");
            return this;
        }

        public Builder time(Date time) {
            this.time = time;
            this.__explicitlySet__.add("time");
            return this;
        }

        public CreateCursorDetails build() {
            CreateCursorDetails model = new CreateCursorDetails(this.partition, this.type, this.offset, this.time);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateCursorDetails model) {
            if (model.wasPropertyExplicitlySet("partition")) {
                this.partition(model.getPartition());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("offset")) {
                this.offset(model.getOffset());
            }
            if (model.wasPropertyExplicitlySet("time")) {
                this.time(model.getTime());
            }
            return this;
        }
    }
}

