/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.UpdateGroupDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class UpdateGroupRequest
extends BmcRequest<UpdateGroupDetails> {
    private String streamId;
    private String groupName;
    private UpdateGroupDetails updateGroupDetails;
    private String opcRequestId;

    public String getStreamId() {
        return this.streamId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public UpdateGroupDetails getUpdateGroupDetails() {
        return this.updateGroupDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateGroupDetails getBody$() {
        return this.updateGroupDetails;
    }

    public Builder toBuilder() {
        return new Builder().streamId(this.streamId).groupName(this.groupName).updateGroupDetails(this.updateGroupDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamId=").append(String.valueOf(this.streamId));
        sb.append(",groupName=").append(String.valueOf(this.groupName));
        sb.append(",updateGroupDetails=").append(String.valueOf((Object)this.updateGroupDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamId, other.streamId) && Objects.equals(this.groupName, other.groupName) && Objects.equals((Object)this.updateGroupDetails, (Object)other.updateGroupDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.groupName == null ? 43 : this.groupName.hashCode());
        result = result * 59 + (this.updateGroupDetails == null ? 43 : this.updateGroupDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateGroupRequest, UpdateGroupDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamId = null;
        private String groupName = null;
        private UpdateGroupDetails updateGroupDetails = null;
        private String opcRequestId = null;

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public Builder updateGroupDetails(UpdateGroupDetails updateGroupDetails) {
            this.updateGroupDetails = updateGroupDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateGroupRequest o) {
            this.streamId(o.getStreamId());
            this.groupName(o.getGroupName());
            this.updateGroupDetails(o.getUpdateGroupDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateGroupRequest build() {
            UpdateGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateGroupDetails body) {
            this.updateGroupDetails(body);
            return this;
        }

        public UpdateGroupRequest buildWithoutInvocationCallback() {
            UpdateGroupRequest request = new UpdateGroupRequest();
            request.streamId = this.streamId;
            request.groupName = this.groupName;
            request.updateGroupDetails = this.updateGroupDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

