/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.UpdateStreamPoolDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class UpdateStreamPoolRequest
extends BmcRequest<UpdateStreamPoolDetails> {
    private String streamPoolId;
    private UpdateStreamPoolDetails updateStreamPoolDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getStreamPoolId() {
        return this.streamPoolId;
    }

    public UpdateStreamPoolDetails getUpdateStreamPoolDetails() {
        return this.updateStreamPoolDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateStreamPoolDetails getBody$() {
        return this.updateStreamPoolDetails;
    }

    public Builder toBuilder() {
        return new Builder().streamPoolId(this.streamPoolId).updateStreamPoolDetails(this.updateStreamPoolDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamPoolId=").append(String.valueOf(this.streamPoolId));
        sb.append(",updateStreamPoolDetails=").append(String.valueOf((Object)this.updateStreamPoolDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateStreamPoolRequest)) {
            return false;
        }
        UpdateStreamPoolRequest other = (UpdateStreamPoolRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamPoolId, other.streamPoolId) && Objects.equals((Object)this.updateStreamPoolDetails, (Object)other.updateStreamPoolDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamPoolId == null ? 43 : this.streamPoolId.hashCode());
        result = result * 59 + (this.updateStreamPoolDetails == null ? 43 : this.updateStreamPoolDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateStreamPoolRequest, UpdateStreamPoolDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamPoolId = null;
        private UpdateStreamPoolDetails updateStreamPoolDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder streamPoolId(String streamPoolId) {
            this.streamPoolId = streamPoolId;
            return this;
        }

        public Builder updateStreamPoolDetails(UpdateStreamPoolDetails updateStreamPoolDetails) {
            this.updateStreamPoolDetails = updateStreamPoolDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateStreamPoolRequest o) {
            this.streamPoolId(o.getStreamPoolId());
            this.updateStreamPoolDetails(o.getUpdateStreamPoolDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateStreamPoolRequest build() {
            UpdateStreamPoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateStreamPoolDetails body) {
            this.updateStreamPoolDetails(body);
            return this;
        }

        public UpdateStreamPoolRequest buildWithoutInvocationCallback() {
            UpdateStreamPoolRequest request = new UpdateStreamPoolRequest();
            request.streamPoolId = this.streamPoolId;
            request.updateStreamPoolDetails = this.updateStreamPoolDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

