/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAdminAsync;
import com.oracle.bmc.streaming.model.ConnectHarness;
import com.oracle.bmc.streaming.model.ConnectHarnessSummary;
import com.oracle.bmc.streaming.model.Stream;
import com.oracle.bmc.streaming.model.StreamPool;
import com.oracle.bmc.streaming.model.StreamPoolSummary;
import com.oracle.bmc.streaming.model.StreamSummary;
import com.oracle.bmc.streaming.requests.ChangeConnectHarnessCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamPoolCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.CreateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamPoolRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.GetStreamPoolRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListConnectHarnessesRequest;
import com.oracle.bmc.streaming.requests.ListStreamPoolsRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.UpdateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeConnectHarnessCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamPoolCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.CreateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamPoolResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.GetStreamPoolResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListConnectHarnessesResponse;
import com.oracle.bmc.streaming.responses.ListStreamPoolsResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.UpdateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAdminAsyncClient
extends BaseAsyncClient
implements StreamAdminAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAMADMIN").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(StreamAdminAsyncClient.class);

    StreamAdminAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeConnectHarnessCompartmentResponse> changeConnectHarnessCompartment(ChangeConnectHarnessCompartmentRequest request, AsyncHandler<ChangeConnectHarnessCompartmentRequest, ChangeConnectHarnessCompartmentResponse> handler) {
        Validate.notBlank((String)request.getConnectHarnessId(), (String)"connectHarnessId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeConnectHarnessCompartmentDetails(), "changeConnectHarnessCompartmentDetails is required");
        return this.clientCall(request, ChangeConnectHarnessCompartmentResponse::builder).logger(LOG, "changeConnectHarnessCompartment").serviceDetails("StreamAdmin", "ChangeConnectHarnessCompartment", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/ChangeConnectHarnessCompartment").method(Method.POST).requestBuilder(ChangeConnectHarnessCompartmentRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendPathParam(request.getConnectHarnessId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeConnectHarnessCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeStreamCompartmentResponse> changeStreamCompartment(ChangeStreamCompartmentRequest request, AsyncHandler<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> handler) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeStreamCompartmentDetails(), "changeStreamCompartmentDetails is required");
        return this.clientCall(request, ChangeStreamCompartmentResponse::builder).logger(LOG, "changeStreamCompartment").serviceDetails("StreamAdmin", "ChangeStreamCompartment", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/ChangeStreamCompartment").method(Method.POST).requestBuilder(ChangeStreamCompartmentRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeStreamCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeStreamPoolCompartmentResponse> changeStreamPoolCompartment(ChangeStreamPoolCompartmentRequest request, AsyncHandler<ChangeStreamPoolCompartmentRequest, ChangeStreamPoolCompartmentResponse> handler) {
        Validate.notBlank((String)request.getStreamPoolId(), (String)"streamPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeStreamPoolCompartmentDetails(), "changeStreamPoolCompartmentDetails is required");
        return this.clientCall(request, ChangeStreamPoolCompartmentResponse::builder).logger(LOG, "changeStreamPoolCompartment").serviceDetails("StreamAdmin", "ChangeStreamPoolCompartment", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/ChangeStreamPoolCompartment").method(Method.POST).requestBuilder(ChangeStreamPoolCompartmentRequest::builder).basePath("/20180418").appendPathParam("streampools").appendPathParam(request.getStreamPoolId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeStreamPoolCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateConnectHarnessResponse> createConnectHarness(CreateConnectHarnessRequest request, AsyncHandler<CreateConnectHarnessRequest, CreateConnectHarnessResponse> handler) {
        Objects.requireNonNull(request.getCreateConnectHarnessDetails(), "createConnectHarnessDetails is required");
        return this.clientCall(request, CreateConnectHarnessResponse::builder).logger(LOG, "createConnectHarness").serviceDetails("StreamAdmin", "CreateConnectHarness", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/CreateConnectHarness").method(Method.POST).requestBuilder(CreateConnectHarnessRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ConnectHarness.class, CreateConnectHarnessResponse.Builder::connectHarness).handleResponseHeaderString("opc-request-id", CreateConnectHarnessResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConnectHarnessResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateStreamResponse> createStream(CreateStreamRequest request, AsyncHandler<CreateStreamRequest, CreateStreamResponse> handler) {
        Objects.requireNonNull(request.getCreateStreamDetails(), "createStreamDetails is required");
        return this.clientCall(request, CreateStreamResponse::builder).logger(LOG, "createStream").serviceDetails("StreamAdmin", "CreateStream", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/CreateStream").method(Method.POST).requestBuilder(CreateStreamRequest::builder).basePath("/20180418").appendPathParam("streams").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Stream.class, CreateStreamResponse.Builder::stream).handleResponseHeaderString("opc-request-id", CreateStreamResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateStreamResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateStreamPoolResponse> createStreamPool(CreateStreamPoolRequest request, AsyncHandler<CreateStreamPoolRequest, CreateStreamPoolResponse> handler) {
        Objects.requireNonNull(request.getCreateStreamPoolDetails(), "createStreamPoolDetails is required");
        return this.clientCall(request, CreateStreamPoolResponse::builder).logger(LOG, "createStreamPool").serviceDetails("StreamAdmin", "CreateStreamPool", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/CreateStreamPool").method(Method.POST).requestBuilder(CreateStreamPoolRequest::builder).basePath("/20180418").appendPathParam("streampools").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(StreamPool.class, CreateStreamPoolResponse.Builder::streamPool).handleResponseHeaderString("opc-request-id", CreateStreamPoolResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateStreamPoolResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteConnectHarnessResponse> deleteConnectHarness(DeleteConnectHarnessRequest request, AsyncHandler<DeleteConnectHarnessRequest, DeleteConnectHarnessResponse> handler) {
        Validate.notBlank((String)request.getConnectHarnessId(), (String)"connectHarnessId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConnectHarnessResponse::builder).logger(LOG, "deleteConnectHarness").serviceDetails("StreamAdmin", "DeleteConnectHarness", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/DeleteConnectHarness").method(Method.DELETE).requestBuilder(DeleteConnectHarnessRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendPathParam(request.getConnectHarnessId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteConnectHarnessResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteStreamResponse> deleteStream(DeleteStreamRequest request, AsyncHandler<DeleteStreamRequest, DeleteStreamResponse> handler) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteStreamResponse::builder).logger(LOG, "deleteStream").serviceDetails("StreamAdmin", "DeleteStream", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/DeleteStream").method(Method.DELETE).requestBuilder(DeleteStreamRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStreamResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteStreamPoolResponse> deleteStreamPool(DeleteStreamPoolRequest request, AsyncHandler<DeleteStreamPoolRequest, DeleteStreamPoolResponse> handler) {
        Validate.notBlank((String)request.getStreamPoolId(), (String)"streamPoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteStreamPoolResponse::builder).logger(LOG, "deleteStreamPool").serviceDetails("StreamAdmin", "DeleteStreamPool", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/DeleteStreamPool").method(Method.DELETE).requestBuilder(DeleteStreamPoolRequest::builder).basePath("/20180418").appendPathParam("streampools").appendPathParam(request.getStreamPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStreamPoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConnectHarnessResponse> getConnectHarness(GetConnectHarnessRequest request, AsyncHandler<GetConnectHarnessRequest, GetConnectHarnessResponse> handler) {
        Validate.notBlank((String)request.getConnectHarnessId(), (String)"connectHarnessId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectHarnessResponse::builder).logger(LOG, "getConnectHarness").serviceDetails("StreamAdmin", "GetConnectHarness", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/GetConnectHarness").method(Method.GET).requestBuilder(GetConnectHarnessRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendPathParam(request.getConnectHarnessId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectHarness.class, GetConnectHarnessResponse.Builder::connectHarness).handleResponseHeaderString("opc-request-id", GetConnectHarnessResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetConnectHarnessResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetStreamResponse> getStream(GetStreamRequest request, AsyncHandler<GetStreamRequest, GetStreamResponse> handler) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetStreamResponse::builder).logger(LOG, "getStream").serviceDetails("StreamAdmin", "GetStream", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/GetStream").method(Method.GET).requestBuilder(GetStreamRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Stream.class, GetStreamResponse.Builder::stream).handleResponseHeaderString("opc-request-id", GetStreamResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetStreamResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetStreamPoolResponse> getStreamPool(GetStreamPoolRequest request, AsyncHandler<GetStreamPoolRequest, GetStreamPoolResponse> handler) {
        Validate.notBlank((String)request.getStreamPoolId(), (String)"streamPoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetStreamPoolResponse::builder).logger(LOG, "getStreamPool").serviceDetails("StreamAdmin", "GetStreamPool", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool").method(Method.GET).requestBuilder(GetStreamPoolRequest::builder).basePath("/20180418").appendPathParam("streampools").appendPathParam(request.getStreamPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StreamPool.class, GetStreamPoolResponse.Builder::streamPool).handleResponseHeaderString("opc-request-id", GetStreamPoolResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetStreamPoolResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListConnectHarnessesResponse> listConnectHarnesses(ListConnectHarnessesRequest request, AsyncHandler<ListConnectHarnessesRequest, ListConnectHarnessesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListConnectHarnessesResponse::builder).logger(LOG, "listConnectHarnesses").serviceDetails("StreamAdmin", "ListConnectHarnesses", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarnessSummary/ListConnectHarnesses").method(Method.GET).requestBuilder(ListConnectHarnessesRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ConnectHarnessSummary.class, ListConnectHarnessesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListConnectHarnessesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListConnectHarnessesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListConnectHarnessesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListStreamPoolsResponse> listStreamPools(ListStreamPoolsRequest request, AsyncHandler<ListStreamPoolsRequest, ListStreamPoolsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListStreamPoolsResponse::builder).logger(LOG, "listStreamPools").serviceDetails("StreamAdmin", "ListStreamPools", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPoolSummary/ListStreamPools").method(Method.GET).requestBuilder(ListStreamPoolsRequest::builder).basePath("/20180418").appendPathParam("streampools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(StreamPoolSummary.class, ListStreamPoolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListStreamPoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListStreamPoolsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListStreamPoolsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListStreamsResponse> listStreams(ListStreamsRequest request, AsyncHandler<ListStreamsRequest, ListStreamsResponse> handler) {
        return this.clientCall(request, ListStreamsResponse::builder).logger(LOG, "listStreams").serviceDetails("StreamAdmin", "ListStreams", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamSummary/ListStreams").method(Method.GET).requestBuilder(ListStreamsRequest::builder).basePath("/20180418").appendPathParam("streams").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("streamPoolId", (Object)request.getStreamPoolId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(StreamSummary.class, ListStreamsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListStreamsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListStreamsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListStreamsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateConnectHarnessResponse> updateConnectHarness(UpdateConnectHarnessRequest request, AsyncHandler<UpdateConnectHarnessRequest, UpdateConnectHarnessResponse> handler) {
        Validate.notBlank((String)request.getConnectHarnessId(), (String)"connectHarnessId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectHarnessDetails(), "updateConnectHarnessDetails is required");
        return this.clientCall(request, UpdateConnectHarnessResponse::builder).logger(LOG, "updateConnectHarness").serviceDetails("StreamAdmin", "UpdateConnectHarness", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/UpdateConnectHarness").method(Method.PUT).requestBuilder(UpdateConnectHarnessRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendPathParam(request.getConnectHarnessId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ConnectHarness.class, UpdateConnectHarnessResponse.Builder::connectHarness).handleResponseHeaderString("opc-request-id", UpdateConnectHarnessResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateConnectHarnessResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateStreamResponse> updateStream(UpdateStreamRequest request, AsyncHandler<UpdateStreamRequest, UpdateStreamResponse> handler) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStreamDetails(), "updateStreamDetails is required");
        return this.clientCall(request, UpdateStreamResponse::builder).logger(LOG, "updateStream").serviceDetails("StreamAdmin", "UpdateStream", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/UpdateStream").method(Method.PUT).requestBuilder(UpdateStreamRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Stream.class, UpdateStreamResponse.Builder::stream).handleResponseHeaderString("opc-request-id", UpdateStreamResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateStreamResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateStreamPoolResponse> updateStreamPool(UpdateStreamPoolRequest request, AsyncHandler<UpdateStreamPoolRequest, UpdateStreamPoolResponse> handler) {
        Validate.notBlank((String)request.getStreamPoolId(), (String)"streamPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStreamPoolDetails(), "updateStreamPoolDetails is required");
        return this.clientCall(request, UpdateStreamPoolResponse::builder).logger(LOG, "updateStreamPool").serviceDetails("StreamAdmin", "UpdateStreamPool", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/UpdateStreamPool").method(Method.PUT).requestBuilder(UpdateStreamPoolRequest::builder).basePath("/20180418").appendPathParam("streampools").appendPathParam(request.getStreamPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(StreamPool.class, UpdateStreamPoolResponse.Builder::streamPool).handleResponseHeaderString("opc-request-id", UpdateStreamPoolResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateStreamPoolResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)StreamAdminAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(StreamAdminAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)StreamAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)StreamAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)StreamAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)StreamAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)StreamAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAdminAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public StreamAdminAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new StreamAdminAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

