/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.streaming.StreamAdmin;
import com.oracle.bmc.streaming.StreamAdminPaginators;
import com.oracle.bmc.streaming.StreamAdminWaiters;
import com.oracle.bmc.streaming.model.ConnectHarness;
import com.oracle.bmc.streaming.model.ConnectHarnessSummary;
import com.oracle.bmc.streaming.model.Stream;
import com.oracle.bmc.streaming.model.StreamPool;
import com.oracle.bmc.streaming.model.StreamPoolSummary;
import com.oracle.bmc.streaming.model.StreamSummary;
import com.oracle.bmc.streaming.requests.ChangeConnectHarnessCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamPoolCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.CreateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamPoolRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.GetStreamPoolRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListConnectHarnessesRequest;
import com.oracle.bmc.streaming.requests.ListStreamPoolsRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.UpdateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeConnectHarnessCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamPoolCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.CreateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamPoolResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.GetStreamPoolResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListConnectHarnessesResponse;
import com.oracle.bmc.streaming.responses.ListStreamPoolsResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.UpdateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAdminClient
extends BaseSyncClient
implements StreamAdmin {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAMADMIN").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(StreamAdminClient.class);
    private final StreamAdminWaiters waiters;
    private final StreamAdminPaginators paginators;

    StreamAdminClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("StreamAdmin-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new StreamAdminWaiters(executorService, this);
        this.paginators = new StreamAdminPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeConnectHarnessCompartmentResponse changeConnectHarnessCompartment(ChangeConnectHarnessCompartmentRequest request) {
        Validate.notBlank((String)request.getConnectHarnessId(), (String)"connectHarnessId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeConnectHarnessCompartmentDetails(), "changeConnectHarnessCompartmentDetails is required");
        return (ChangeConnectHarnessCompartmentResponse)this.clientCall(request, ChangeConnectHarnessCompartmentResponse::builder).logger(LOG, "changeConnectHarnessCompartment").serviceDetails("StreamAdmin", "ChangeConnectHarnessCompartment", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/ChangeConnectHarnessCompartment").method(Method.POST).requestBuilder(ChangeConnectHarnessCompartmentRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendPathParam(request.getConnectHarnessId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeConnectHarnessCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeStreamCompartmentResponse changeStreamCompartment(ChangeStreamCompartmentRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeStreamCompartmentDetails(), "changeStreamCompartmentDetails is required");
        return (ChangeStreamCompartmentResponse)this.clientCall(request, ChangeStreamCompartmentResponse::builder).logger(LOG, "changeStreamCompartment").serviceDetails("StreamAdmin", "ChangeStreamCompartment", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/ChangeStreamCompartment").method(Method.POST).requestBuilder(ChangeStreamCompartmentRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeStreamCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeStreamPoolCompartmentResponse changeStreamPoolCompartment(ChangeStreamPoolCompartmentRequest request) {
        Validate.notBlank((String)request.getStreamPoolId(), (String)"streamPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeStreamPoolCompartmentDetails(), "changeStreamPoolCompartmentDetails is required");
        return (ChangeStreamPoolCompartmentResponse)this.clientCall(request, ChangeStreamPoolCompartmentResponse::builder).logger(LOG, "changeStreamPoolCompartment").serviceDetails("StreamAdmin", "ChangeStreamPoolCompartment", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/ChangeStreamPoolCompartment").method(Method.POST).requestBuilder(ChangeStreamPoolCompartmentRequest::builder).basePath("/20180418").appendPathParam("streampools").appendPathParam(request.getStreamPoolId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeStreamPoolCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateConnectHarnessResponse createConnectHarness(CreateConnectHarnessRequest request) {
        Objects.requireNonNull(request.getCreateConnectHarnessDetails(), "createConnectHarnessDetails is required");
        return (CreateConnectHarnessResponse)this.clientCall(request, CreateConnectHarnessResponse::builder).logger(LOG, "createConnectHarness").serviceDetails("StreamAdmin", "CreateConnectHarness", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/CreateConnectHarness").method(Method.POST).requestBuilder(CreateConnectHarnessRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ConnectHarness.class, CreateConnectHarnessResponse.Builder::connectHarness).handleResponseHeaderString("opc-request-id", CreateConnectHarnessResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConnectHarnessResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateStreamResponse createStream(CreateStreamRequest request) {
        Objects.requireNonNull(request.getCreateStreamDetails(), "createStreamDetails is required");
        return (CreateStreamResponse)this.clientCall(request, CreateStreamResponse::builder).logger(LOG, "createStream").serviceDetails("StreamAdmin", "CreateStream", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/CreateStream").method(Method.POST).requestBuilder(CreateStreamRequest::builder).basePath("/20180418").appendPathParam("streams").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Stream.class, CreateStreamResponse.Builder::stream).handleResponseHeaderString("opc-request-id", CreateStreamResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateStreamResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateStreamPoolResponse createStreamPool(CreateStreamPoolRequest request) {
        Objects.requireNonNull(request.getCreateStreamPoolDetails(), "createStreamPoolDetails is required");
        return (CreateStreamPoolResponse)this.clientCall(request, CreateStreamPoolResponse::builder).logger(LOG, "createStreamPool").serviceDetails("StreamAdmin", "CreateStreamPool", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/CreateStreamPool").method(Method.POST).requestBuilder(CreateStreamPoolRequest::builder).basePath("/20180418").appendPathParam("streampools").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(StreamPool.class, CreateStreamPoolResponse.Builder::streamPool).handleResponseHeaderString("opc-request-id", CreateStreamPoolResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateStreamPoolResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteConnectHarnessResponse deleteConnectHarness(DeleteConnectHarnessRequest request) {
        Validate.notBlank((String)request.getConnectHarnessId(), (String)"connectHarnessId must not be blank", (Object[])new Object[0]);
        return (DeleteConnectHarnessResponse)this.clientCall(request, DeleteConnectHarnessResponse::builder).logger(LOG, "deleteConnectHarness").serviceDetails("StreamAdmin", "DeleteConnectHarness", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/DeleteConnectHarness").method(Method.DELETE).requestBuilder(DeleteConnectHarnessRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendPathParam(request.getConnectHarnessId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteConnectHarnessResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteStreamResponse deleteStream(DeleteStreamRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        return (DeleteStreamResponse)this.clientCall(request, DeleteStreamResponse::builder).logger(LOG, "deleteStream").serviceDetails("StreamAdmin", "DeleteStream", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/DeleteStream").method(Method.DELETE).requestBuilder(DeleteStreamRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStreamResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteStreamPoolResponse deleteStreamPool(DeleteStreamPoolRequest request) {
        Validate.notBlank((String)request.getStreamPoolId(), (String)"streamPoolId must not be blank", (Object[])new Object[0]);
        return (DeleteStreamPoolResponse)this.clientCall(request, DeleteStreamPoolResponse::builder).logger(LOG, "deleteStreamPool").serviceDetails("StreamAdmin", "DeleteStreamPool", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/DeleteStreamPool").method(Method.DELETE).requestBuilder(DeleteStreamPoolRequest::builder).basePath("/20180418").appendPathParam("streampools").appendPathParam(request.getStreamPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteStreamPoolResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetConnectHarnessResponse getConnectHarness(GetConnectHarnessRequest request) {
        Validate.notBlank((String)request.getConnectHarnessId(), (String)"connectHarnessId must not be blank", (Object[])new Object[0]);
        return (GetConnectHarnessResponse)this.clientCall(request, GetConnectHarnessResponse::builder).logger(LOG, "getConnectHarness").serviceDetails("StreamAdmin", "GetConnectHarness", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/GetConnectHarness").method(Method.GET).requestBuilder(GetConnectHarnessRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendPathParam(request.getConnectHarnessId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectHarness.class, GetConnectHarnessResponse.Builder::connectHarness).handleResponseHeaderString("opc-request-id", GetConnectHarnessResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetConnectHarnessResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStreamResponse getStream(GetStreamRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        return (GetStreamResponse)this.clientCall(request, GetStreamResponse::builder).logger(LOG, "getStream").serviceDetails("StreamAdmin", "GetStream", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/GetStream").method(Method.GET).requestBuilder(GetStreamRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Stream.class, GetStreamResponse.Builder::stream).handleResponseHeaderString("opc-request-id", GetStreamResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetStreamResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStreamPoolResponse getStreamPool(GetStreamPoolRequest request) {
        Validate.notBlank((String)request.getStreamPoolId(), (String)"streamPoolId must not be blank", (Object[])new Object[0]);
        return (GetStreamPoolResponse)this.clientCall(request, GetStreamPoolResponse::builder).logger(LOG, "getStreamPool").serviceDetails("StreamAdmin", "GetStreamPool", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool").method(Method.GET).requestBuilder(GetStreamPoolRequest::builder).basePath("/20180418").appendPathParam("streampools").appendPathParam(request.getStreamPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StreamPool.class, GetStreamPoolResponse.Builder::streamPool).handleResponseHeaderString("opc-request-id", GetStreamPoolResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetStreamPoolResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListConnectHarnessesResponse listConnectHarnesses(ListConnectHarnessesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListConnectHarnessesResponse)this.clientCall(request, ListConnectHarnessesResponse::builder).logger(LOG, "listConnectHarnesses").serviceDetails("StreamAdmin", "ListConnectHarnesses", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarnessSummary/ListConnectHarnesses").method(Method.GET).requestBuilder(ListConnectHarnessesRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ConnectHarnessSummary.class, ListConnectHarnessesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListConnectHarnessesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListConnectHarnessesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListConnectHarnessesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStreamPoolsResponse listStreamPools(ListStreamPoolsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListStreamPoolsResponse)this.clientCall(request, ListStreamPoolsResponse::builder).logger(LOG, "listStreamPools").serviceDetails("StreamAdmin", "ListStreamPools", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPoolSummary/ListStreamPools").method(Method.GET).requestBuilder(ListStreamPoolsRequest::builder).basePath("/20180418").appendPathParam("streampools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(StreamPoolSummary.class, ListStreamPoolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListStreamPoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListStreamPoolsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListStreamPoolsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest request) {
        return (ListStreamsResponse)this.clientCall(request, ListStreamsResponse::builder).logger(LOG, "listStreams").serviceDetails("StreamAdmin", "ListStreams", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamSummary/ListStreams").method(Method.GET).requestBuilder(ListStreamsRequest::builder).basePath("/20180418").appendPathParam("streams").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("streamPoolId", (Object)request.getStreamPoolId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(StreamSummary.class, ListStreamsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListStreamsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListStreamsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListStreamsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateConnectHarnessResponse updateConnectHarness(UpdateConnectHarnessRequest request) {
        Validate.notBlank((String)request.getConnectHarnessId(), (String)"connectHarnessId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectHarnessDetails(), "updateConnectHarnessDetails is required");
        return (UpdateConnectHarnessResponse)this.clientCall(request, UpdateConnectHarnessResponse::builder).logger(LOG, "updateConnectHarness").serviceDetails("StreamAdmin", "UpdateConnectHarness", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/UpdateConnectHarness").method(Method.PUT).requestBuilder(UpdateConnectHarnessRequest::builder).basePath("/20180418").appendPathParam("connectharnesses").appendPathParam(request.getConnectHarnessId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ConnectHarness.class, UpdateConnectHarnessResponse.Builder::connectHarness).handleResponseHeaderString("opc-request-id", UpdateConnectHarnessResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateConnectHarnessResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateStreamResponse updateStream(UpdateStreamRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStreamDetails(), "updateStreamDetails is required");
        return (UpdateStreamResponse)this.clientCall(request, UpdateStreamResponse::builder).logger(LOG, "updateStream").serviceDetails("StreamAdmin", "UpdateStream", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/UpdateStream").method(Method.PUT).requestBuilder(UpdateStreamRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Stream.class, UpdateStreamResponse.Builder::stream).handleResponseHeaderString("opc-request-id", UpdateStreamResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateStreamResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateStreamPoolResponse updateStreamPool(UpdateStreamPoolRequest request) {
        Validate.notBlank((String)request.getStreamPoolId(), (String)"streamPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStreamPoolDetails(), "updateStreamPoolDetails is required");
        return (UpdateStreamPoolResponse)this.clientCall(request, UpdateStreamPoolResponse::builder).logger(LOG, "updateStreamPool").serviceDetails("StreamAdmin", "UpdateStreamPool", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/UpdateStreamPool").method(Method.PUT).requestBuilder(UpdateStreamPoolRequest::builder).basePath("/20180418").appendPathParam("streampools").appendPathParam(request.getStreamPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(StreamPool.class, UpdateStreamPoolResponse.Builder::streamPool).handleResponseHeaderString("opc-request-id", UpdateStreamPoolResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateStreamPoolResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public StreamAdminWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public StreamAdminPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)StreamAdminClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(StreamAdminClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)StreamAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)StreamAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)StreamAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)StreamAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)StreamAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)StreamAdminClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAdminClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public StreamAdminClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new StreamAdminClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

