/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateStreamDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="partitions")
    private final Integer partitions;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="streamPoolId")
    private final String streamPoolId;
    @JsonProperty(value="retentionInHours")
    private final Integer retentionInHours;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"name", "partitions", "compartmentId", "streamPoolId", "retentionInHours", "freeformTags", "definedTags"})
    public CreateStreamDetails(String name, Integer partitions, String compartmentId, String streamPoolId, Integer retentionInHours, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.name = name;
        this.partitions = partitions;
        this.compartmentId = compartmentId;
        this.streamPoolId = streamPoolId;
        this.retentionInHours = retentionInHours;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getPartitions() {
        return this.partitions;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getStreamPoolId() {
        return this.streamPoolId;
    }

    public Integer getRetentionInHours() {
        return this.retentionInHours;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateStreamDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", partitions=").append(String.valueOf(this.partitions));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", streamPoolId=").append(String.valueOf(this.streamPoolId));
        sb.append(", retentionInHours=").append(String.valueOf(this.retentionInHours));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateStreamDetails)) {
            return false;
        }
        CreateStreamDetails other = (CreateStreamDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.partitions, other.partitions) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.streamPoolId, other.streamPoolId) && Objects.equals(this.retentionInHours, other.retentionInHours) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.partitions == null ? 43 : this.partitions.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.streamPoolId == null ? 43 : this.streamPoolId.hashCode());
        result = result * 59 + (this.retentionInHours == null ? 43 : this.retentionInHours.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="partitions")
        private Integer partitions;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="streamPoolId")
        private String streamPoolId;
        @JsonProperty(value="retentionInHours")
        private Integer retentionInHours;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder partitions(Integer partitions) {
            this.partitions = partitions;
            this.__explicitlySet__.add("partitions");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder streamPoolId(String streamPoolId) {
            this.streamPoolId = streamPoolId;
            this.__explicitlySet__.add("streamPoolId");
            return this;
        }

        public Builder retentionInHours(Integer retentionInHours) {
            this.retentionInHours = retentionInHours;
            this.__explicitlySet__.add("retentionInHours");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateStreamDetails build() {
            CreateStreamDetails model = new CreateStreamDetails(this.name, this.partitions, this.compartmentId, this.streamPoolId, this.retentionInHours, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateStreamDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("partitions")) {
                this.partitions(model.getPartitions());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("streamPoolId")) {
                this.streamPoolId(model.getStreamPoolId());
            }
            if (model.wasPropertyExplicitlySet("retentionInHours")) {
                this.retentionInHours(model.getRetentionInHours());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

