/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PartitionReservation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="partition")
    private final String partition;
    @JsonProperty(value="committedOffset")
    private final Long committedOffset;
    @JsonProperty(value="reservedInstance")
    private final String reservedInstance;
    @JsonProperty(value="timeReservedUntil")
    private final Date timeReservedUntil;

    @Deprecated
    @ConstructorProperties(value={"partition", "committedOffset", "reservedInstance", "timeReservedUntil"})
    public PartitionReservation(String partition, Long committedOffset, String reservedInstance, Date timeReservedUntil) {
        this.partition = partition;
        this.committedOffset = committedOffset;
        this.reservedInstance = reservedInstance;
        this.timeReservedUntil = timeReservedUntil;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPartition() {
        return this.partition;
    }

    public Long getCommittedOffset() {
        return this.committedOffset;
    }

    public String getReservedInstance() {
        return this.reservedInstance;
    }

    public Date getTimeReservedUntil() {
        return this.timeReservedUntil;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionReservation(");
        sb.append("super=").append(super.toString());
        sb.append("partition=").append(String.valueOf(this.partition));
        sb.append(", committedOffset=").append(String.valueOf(this.committedOffset));
        sb.append(", reservedInstance=").append(String.valueOf(this.reservedInstance));
        sb.append(", timeReservedUntil=").append(String.valueOf(this.timeReservedUntil));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionReservation)) {
            return false;
        }
        PartitionReservation other = (PartitionReservation)((Object)o);
        return Objects.equals(this.partition, other.partition) && Objects.equals(this.committedOffset, other.committedOffset) && Objects.equals(this.reservedInstance, other.reservedInstance) && Objects.equals(this.timeReservedUntil, other.timeReservedUntil) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.partition == null ? 43 : this.partition.hashCode());
        result = result * 59 + (this.committedOffset == null ? 43 : this.committedOffset.hashCode());
        result = result * 59 + (this.reservedInstance == null ? 43 : this.reservedInstance.hashCode());
        result = result * 59 + (this.timeReservedUntil == null ? 43 : this.timeReservedUntil.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="partition")
        private String partition;
        @JsonProperty(value="committedOffset")
        private Long committedOffset;
        @JsonProperty(value="reservedInstance")
        private String reservedInstance;
        @JsonProperty(value="timeReservedUntil")
        private Date timeReservedUntil;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder partition(String partition) {
            this.partition = partition;
            this.__explicitlySet__.add("partition");
            return this;
        }

        public Builder committedOffset(Long committedOffset) {
            this.committedOffset = committedOffset;
            this.__explicitlySet__.add("committedOffset");
            return this;
        }

        public Builder reservedInstance(String reservedInstance) {
            this.reservedInstance = reservedInstance;
            this.__explicitlySet__.add("reservedInstance");
            return this;
        }

        public Builder timeReservedUntil(Date timeReservedUntil) {
            this.timeReservedUntil = timeReservedUntil;
            this.__explicitlySet__.add("timeReservedUntil");
            return this;
        }

        public PartitionReservation build() {
            PartitionReservation model = new PartitionReservation(this.partition, this.committedOffset, this.reservedInstance, this.timeReservedUntil);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PartitionReservation model) {
            if (model.wasPropertyExplicitlySet("partition")) {
                this.partition(model.getPartition());
            }
            if (model.wasPropertyExplicitlySet("committedOffset")) {
                this.committedOffset(model.getCommittedOffset());
            }
            if (model.wasPropertyExplicitlySet("reservedInstance")) {
                this.reservedInstance(model.getReservedInstance());
            }
            if (model.wasPropertyExplicitlySet("timeReservedUntil")) {
                this.timeReservedUntil(model.getTimeReservedUntil());
            }
            return this;
        }
    }
}

