/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetGroupRequest
extends BmcRequest<Void> {
    private String streamId;
    private String groupName;
    private String opcRequestId;

    public String getStreamId() {
        return this.streamId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().streamId(this.streamId).groupName(this.groupName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamId=").append(String.valueOf(this.streamId));
        sb.append(",groupName=").append(String.valueOf(this.groupName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetGroupRequest)) {
            return false;
        }
        GetGroupRequest other = (GetGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamId, other.streamId) && Objects.equals(this.groupName, other.groupName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.groupName == null ? 43 : this.groupName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamId = null;
        private String groupName = null;
        private String opcRequestId = null;

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetGroupRequest o) {
            this.streamId(o.getStreamId());
            this.groupName(o.getGroupName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetGroupRequest build() {
            GetGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetGroupRequest buildWithoutInvocationCallback() {
            GetGroupRequest request = new GetGroupRequest();
            request.streamId = this.streamId;
            request.groupName = this.groupName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

