/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMessagesRequest
extends BmcRequest<Void> {
    private String streamId;
    private String cursor;
    private Integer limit;
    private String opcRequestId;

    public String getStreamId() {
        return this.streamId;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().streamId(this.streamId).cursor(this.cursor).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamId=").append(String.valueOf(this.streamId));
        sb.append(",cursor=").append(String.valueOf(this.cursor));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMessagesRequest)) {
            return false;
        }
        GetMessagesRequest other = (GetMessagesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamId, other.streamId) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.cursor == null ? 43 : this.cursor.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMessagesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamId = null;
        private String cursor = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMessagesRequest o) {
            this.streamId(o.getStreamId());
            this.cursor(o.getCursor());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMessagesRequest build() {
            GetMessagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMessagesRequest buildWithoutInvocationCallback() {
            GetMessagesRequest request = new GetMessagesRequest();
            request.streamId = this.streamId;
            request.cursor = this.cursor;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

