/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.streaming.Stream;
import com.oracle.bmc.streaming.StreamClientBuilder;
import com.oracle.bmc.streaming.model.Cursor;
import com.oracle.bmc.streaming.model.Group;
import com.oracle.bmc.streaming.model.Message;
import com.oracle.bmc.streaming.model.PutMessagesResult;
import com.oracle.bmc.streaming.requests.ConsumerCommitRequest;
import com.oracle.bmc.streaming.requests.ConsumerHeartbeatRequest;
import com.oracle.bmc.streaming.requests.CreateCursorRequest;
import com.oracle.bmc.streaming.requests.CreateGroupCursorRequest;
import com.oracle.bmc.streaming.requests.GetGroupRequest;
import com.oracle.bmc.streaming.requests.GetMessagesRequest;
import com.oracle.bmc.streaming.requests.PutMessagesRequest;
import com.oracle.bmc.streaming.requests.UpdateGroupRequest;
import com.oracle.bmc.streaming.responses.ConsumerCommitResponse;
import com.oracle.bmc.streaming.responses.ConsumerHeartbeatResponse;
import com.oracle.bmc.streaming.responses.CreateCursorResponse;
import com.oracle.bmc.streaming.responses.CreateGroupCursorResponse;
import com.oracle.bmc.streaming.responses.GetGroupResponse;
import com.oracle.bmc.streaming.responses.GetMessagesResponse;
import com.oracle.bmc.streaming.responses.PutMessagesResponse;
import com.oracle.bmc.streaming.responses.UpdateGroupResponse;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamClient
extends BaseSyncClient
implements Stream {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAM").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(StreamClient.class);

    StreamClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, null);
    }

    public static StreamClientBuilder builder() {
        return new StreamClientBuilder(SERVICE);
    }

    @Override
    public ConsumerCommitResponse consumerCommit(ConsumerCommitRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCursor(), "cursor is required");
        return (ConsumerCommitResponse)this.clientCall(request, ConsumerCommitResponse::builder).logger(LOG, "consumerCommit").serviceDetails("Stream", "ConsumerCommit", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/ConsumerCommit").method(Method.POST).requestBuilder(ConsumerCommitRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("commit").appendQueryParam("cursor", (Object)request.getCursor()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Cursor.class, ConsumerCommitResponse.Builder::cursor).handleResponseHeaderString("opc-request-id", ConsumerCommitResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ConsumerHeartbeatResponse consumerHeartbeat(ConsumerHeartbeatRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCursor(), "cursor is required");
        return (ConsumerHeartbeatResponse)this.clientCall(request, ConsumerHeartbeatResponse::builder).logger(LOG, "consumerHeartbeat").serviceDetails("Stream", "ConsumerHeartbeat", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/ConsumerHeartbeat").method(Method.POST).requestBuilder(ConsumerHeartbeatRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("heartbeat").appendQueryParam("cursor", (Object)request.getCursor()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Cursor.class, ConsumerHeartbeatResponse.Builder::cursor).handleResponseHeaderString("opc-request-id", ConsumerHeartbeatResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCursorResponse createCursor(CreateCursorRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateCursorDetails(), "createCursorDetails is required");
        return (CreateCursorResponse)this.clientCall(request, CreateCursorResponse::builder).logger(LOG, "createCursor").serviceDetails("Stream", "CreateCursor", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Cursor/CreateCursor").method(Method.POST).requestBuilder(CreateCursorRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("cursors").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Cursor.class, CreateCursorResponse.Builder::cursor).handleResponseHeaderString("opc-request-id", CreateCursorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateGroupCursorResponse createGroupCursor(CreateGroupCursorRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateGroupCursorDetails(), "createGroupCursorDetails is required");
        return (CreateGroupCursorResponse)this.clientCall(request, CreateGroupCursorResponse::builder).logger(LOG, "createGroupCursor").serviceDetails("Stream", "CreateGroupCursor", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Cursor/CreateGroupCursor").method(Method.POST).requestBuilder(CreateGroupCursorRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("groupCursors").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Cursor.class, CreateGroupCursorResponse.Builder::cursor).handleResponseHeaderString("opc-request-id", CreateGroupCursorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetGroupResponse getGroup(GetGroupRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGroupName(), (String)"groupName must not be blank", (Object[])new Object[0]);
        return (GetGroupResponse)this.clientCall(request, GetGroupResponse::builder).logger(LOG, "getGroup").serviceDetails("Stream", "GetGroup", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/GetGroup").method(Method.GET).requestBuilder(GetGroupRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("groups").appendPathParam(request.getGroupName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Group.class, GetGroupResponse.Builder::group).handleResponseHeaderString("opc-request-id", GetGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetMessagesResponse getMessages(GetMessagesRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCursor(), "cursor is required");
        return (GetMessagesResponse)this.clientCall(request, GetMessagesResponse::builder).logger(LOG, "getMessages").serviceDetails("Stream", "GetMessages", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Message/GetMessages").method(Method.GET).requestBuilder(GetMessagesRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("messages").appendQueryParam("cursor", (Object)request.getCursor()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(Message.class, GetMessagesResponse.Builder::items).handleResponseHeaderString("opc-next-cursor", GetMessagesResponse.Builder::opcNextCursor).handleResponseHeaderString("opc-request-id", GetMessagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public PutMessagesResponse putMessages(PutMessagesRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPutMessagesDetails(), "putMessagesDetails is required");
        return (PutMessagesResponse)this.clientCall(request, PutMessagesResponse::builder).logger(LOG, "putMessages").serviceDetails("Stream", "PutMessages", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Message/PutMessages").method(Method.POST).requestBuilder(PutMessagesRequest::builder).obmcsSigningStrategy(SigningStrategy.EXCLUDE_BODY).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("messages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PutMessagesResult.class, PutMessagesResponse.Builder::putMessagesResult).handleResponseHeaderString("opc-request-id", PutMessagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest request) {
        Validate.notBlank((String)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGroupName(), (String)"groupName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateGroupDetails(), "updateGroupDetails is required");
        return (UpdateGroupResponse)this.clientCall(request, UpdateGroupResponse::builder).logger(LOG, "updateGroup").serviceDetails("Stream", "UpdateGroup", "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Group/UpdateGroup").method(Method.PUT).requestBuilder(UpdateGroupRequest::builder).basePath("/20180418").appendPathParam("streams").appendPathParam(request.getStreamId()).appendPathParam("groups").appendPathParam(request.getGroupName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateGroupResponse.Builder::opcRequestId).callSync();
    }

    @Deprecated
    public StreamClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(StreamClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StreamClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(StreamClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StreamClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((StreamClientBuilder)StreamClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((StreamClientBuilder)((StreamClientBuilder)StreamClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((StreamClientBuilder)((StreamClientBuilder)((StreamClientBuilder)StreamClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((StreamClientBuilder)((StreamClientBuilder)((StreamClientBuilder)((StreamClientBuilder)StreamClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public StreamClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((StreamClientBuilder)((StreamClientBuilder)((StreamClientBuilder)((StreamClientBuilder)((StreamClientBuilder)StreamClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }
}

