/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.CreateCursorDetails;
import java.util.Objects;

public class CreateCursorRequest
extends BmcRequest<CreateCursorDetails> {
    private String streamId;
    private CreateCursorDetails createCursorDetails;
    private String opcRequestId;

    public String getStreamId() {
        return this.streamId;
    }

    public CreateCursorDetails getCreateCursorDetails() {
        return this.createCursorDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateCursorDetails getBody$() {
        return this.createCursorDetails;
    }

    public Builder toBuilder() {
        return new Builder().streamId(this.streamId).createCursorDetails(this.createCursorDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamId=").append(String.valueOf(this.streamId));
        sb.append(",createCursorDetails=").append(String.valueOf((Object)this.createCursorDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCursorRequest)) {
            return false;
        }
        CreateCursorRequest other = (CreateCursorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamId, other.streamId) && Objects.equals((Object)this.createCursorDetails, (Object)other.createCursorDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.createCursorDetails == null ? 43 : this.createCursorDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateCursorRequest, CreateCursorDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamId = null;
        private CreateCursorDetails createCursorDetails = null;
        private String opcRequestId = null;

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder createCursorDetails(CreateCursorDetails createCursorDetails) {
            this.createCursorDetails = createCursorDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateCursorRequest o) {
            this.streamId(o.getStreamId());
            this.createCursorDetails(o.getCreateCursorDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateCursorRequest build() {
            CreateCursorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateCursorDetails body) {
            this.createCursorDetails(body);
            return this;
        }

        public CreateCursorRequest buildWithoutInvocationCallback() {
            CreateCursorRequest request = new CreateCursorRequest();
            request.streamId = this.streamId;
            request.createCursorDetails = this.createCursorDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

