/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.Domain;
import com.oracle.bmc.tenantmanagercontrolplane.model.DomainSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListDomainsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListDomainsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class DomainPaginators {
    private final Domain client;

    public Iterable<ListDomainsResponse> listDomainsResponseIterator(final ListDomainsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDomainsRequest.Builder>(){

            public ListDomainsRequest.Builder get() {
                return ListDomainsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDomainsResponse, String>(){

            public String apply(ListDomainsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDomainsRequest.Builder>, ListDomainsRequest>(){

            public ListDomainsRequest apply(RequestBuilderAndToken<ListDomainsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDomainsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDomainsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDomainsRequest, ListDomainsResponse>(){

            public ListDomainsResponse apply(ListDomainsRequest request) {
                return DomainPaginators.this.client.listDomains(request);
            }
        });
    }

    public Iterable<DomainSummary> listDomainsRecordIterator(final ListDomainsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDomainsRequest.Builder>(){

            public ListDomainsRequest.Builder get() {
                return ListDomainsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDomainsResponse, String>(){

            public String apply(ListDomainsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDomainsRequest.Builder>, ListDomainsRequest>(){

            public ListDomainsRequest apply(RequestBuilderAndToken<ListDomainsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDomainsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDomainsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDomainsRequest, ListDomainsResponse>(){

            public ListDomainsResponse apply(ListDomainsRequest request) {
                return DomainPaginators.this.client.listDomains(request);
            }
        }, (Function)new Function<ListDomainsResponse, List<DomainSummary>>(){

            public List<DomainSummary> apply(ListDomainsResponse response) {
                return response.getDomainCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DomainPaginators(Domain client) {
        this.client = client;
    }
}

