/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.SenderInvitation;
import com.oracle.bmc.tenantmanagercontrolplane.model.SenderInvitationSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSenderInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSenderInvitationsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class SenderInvitationPaginators {
    private final SenderInvitation client;

    public Iterable<ListSenderInvitationsResponse> listSenderInvitationsResponseIterator(final ListSenderInvitationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSenderInvitationsRequest.Builder>(){

            public ListSenderInvitationsRequest.Builder get() {
                return ListSenderInvitationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSenderInvitationsResponse, String>(){

            public String apply(ListSenderInvitationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSenderInvitationsRequest.Builder>, ListSenderInvitationsRequest>(){

            public ListSenderInvitationsRequest apply(RequestBuilderAndToken<ListSenderInvitationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSenderInvitationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSenderInvitationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSenderInvitationsRequest, ListSenderInvitationsResponse>(){

            public ListSenderInvitationsResponse apply(ListSenderInvitationsRequest request) {
                return SenderInvitationPaginators.this.client.listSenderInvitations(request);
            }
        });
    }

    public Iterable<SenderInvitationSummary> listSenderInvitationsRecordIterator(final ListSenderInvitationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSenderInvitationsRequest.Builder>(){

            public ListSenderInvitationsRequest.Builder get() {
                return ListSenderInvitationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSenderInvitationsResponse, String>(){

            public String apply(ListSenderInvitationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSenderInvitationsRequest.Builder>, ListSenderInvitationsRequest>(){

            public ListSenderInvitationsRequest apply(RequestBuilderAndToken<ListSenderInvitationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSenderInvitationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSenderInvitationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSenderInvitationsRequest, ListSenderInvitationsResponse>(){

            public ListSenderInvitationsResponse apply(ListSenderInvitationsRequest request) {
                return SenderInvitationPaginators.this.client.listSenderInvitations(request);
            }
        }, (Function)new Function<ListSenderInvitationsResponse, List<SenderInvitationSummary>>(){

            public List<SenderInvitationSummary> apply(ListSenderInvitationsResponse response) {
                return response.getSenderInvitationCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public SenderInvitationPaginators(SenderInvitation client) {
        this.client = client;
    }
}

