/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetLinkRequest
extends BmcRequest<Void> {
    private String linkId;
    private String opcRequestId;

    @ConstructorProperties(value={"linkId", "opcRequestId"})
    GetLinkRequest(String linkId, String opcRequestId) {
        this.linkId = linkId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLinkRequest, Void> {
        private String linkId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLinkRequest o) {
            this.linkId(o.getLinkId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLinkRequest build() {
            GetLinkRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetLinkRequest buildWithoutInvocationCallback() {
            return new GetLinkRequest(this.linkId, this.opcRequestId);
        }

        public String toString() {
            return "GetLinkRequest.Builder(linkId=" + this.linkId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

