/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.tenantmanagercontrolplane.model.LifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.RecipientInvitationStatus;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListRecipientInvitationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String senderTenancyId;
    private LifecycleState lifecycleState;
    private RecipientInvitationStatus status;
    private String opcRequestId;
    private String page;

    @ConstructorProperties(value={"compartmentId", "senderTenancyId", "lifecycleState", "status", "opcRequestId", "page"})
    ListRecipientInvitationsRequest(String compartmentId, String senderTenancyId, LifecycleState lifecycleState, RecipientInvitationStatus status, String opcRequestId, String page) {
        this.compartmentId = compartmentId;
        this.senderTenancyId = senderTenancyId;
        this.lifecycleState = lifecycleState;
        this.status = status;
        this.opcRequestId = opcRequestId;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSenderTenancyId() {
        return this.senderTenancyId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public RecipientInvitationStatus getStatus() {
        return this.status;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRecipientInvitationsRequest, Void> {
        private String compartmentId;
        private String senderTenancyId;
        private LifecycleState lifecycleState;
        private RecipientInvitationStatus status;
        private String opcRequestId;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRecipientInvitationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.senderTenancyId(o.getSenderTenancyId());
            this.lifecycleState(o.getLifecycleState());
            this.status(o.getStatus());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRecipientInvitationsRequest build() {
            ListRecipientInvitationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder senderTenancyId(String senderTenancyId) {
            this.senderTenancyId = senderTenancyId;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder status(RecipientInvitationStatus status) {
            this.status = status;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListRecipientInvitationsRequest buildWithoutInvocationCallback() {
            return new ListRecipientInvitationsRequest(this.compartmentId, this.senderTenancyId, this.lifecycleState, this.status, this.opcRequestId, this.page);
        }

        public String toString() {
            return "ListRecipientInvitationsRequest.Builder(compartmentId=" + this.compartmentId + ", senderTenancyId=" + this.senderTenancyId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", status=" + (Object)((Object)this.status) + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ")";
        }
    }
}

