/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.tenantmanagercontrolplane.DomainPaginators;
import com.oracle.bmc.tenantmanagercontrolplane.DomainWaiters;
import com.oracle.bmc.tenantmanagercontrolplane.model.Domain;
import com.oracle.bmc.tenantmanagercontrolplane.model.DomainCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListDomainsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListDomainsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateDomainResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainClient
extends BaseSyncClient
implements com.oracle.bmc.tenantmanagercontrolplane.Domain {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DOMAIN").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DomainClient.class);
    private final DomainWaiters waiters;
    private final DomainPaginators paginators;

    DomainClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Domain-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DomainWaiters(executorService, this);
        this.paginators = new DomainPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest request) {
        Objects.requireNonNull(request.getCreateDomainDetails(), "createDomainDetails is required");
        return (CreateDomainResponse)this.clientCall(request, CreateDomainResponse::builder).logger(LOG, "createDomain").serviceDetails("Domain", "CreateDomain", "").method(Method.POST).requestBuilder(CreateDomainRequest::builder).basePath("/20230401").appendPathParam("domains").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Domain.class, CreateDomainResponse.Builder::domain).handleResponseHeaderString("opc-request-id", CreateDomainResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateDomainResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest request) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        return (DeleteDomainResponse)this.clientCall(request, DeleteDomainResponse::builder).logger(LOG, "deleteDomain").serviceDetails("Domain", "DeleteDomain", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Domain/DeleteDomain").method(Method.DELETE).requestBuilder(DeleteDomainRequest::builder).basePath("/20230401").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDomainResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDomainResponse getDomain(GetDomainRequest request) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        return (GetDomainResponse)this.clientCall(request, GetDomainResponse::builder).logger(LOG, "getDomain").serviceDetails("Domain", "GetDomain", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Domain/GetDomain").method(Method.GET).requestBuilder(GetDomainRequest::builder).basePath("/20230401").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Domain.class, GetDomainResponse.Builder::domain).handleResponseHeaderString("etag", GetDomainResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDomainResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDomainsResponse)this.clientCall(request, ListDomainsResponse::builder).logger(LOG, "listDomains").serviceDetails("Domain", "ListDomains", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Domain/ListDomains").method(Method.GET).requestBuilder(ListDomainsRequest::builder).basePath("/20230401").appendPathParam("domains").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("domainId", (Object)request.getDomainId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DomainCollection.class, ListDomainsResponse.Builder::domainCollection).handleResponseHeaderString("opc-next-page", ListDomainsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDomainsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDomainResponse updateDomain(UpdateDomainRequest request) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDomainDetails(), "updateDomainDetails is required");
        return (UpdateDomainResponse)this.clientCall(request, UpdateDomainResponse::builder).logger(LOG, "updateDomain").serviceDetails("Domain", "UpdateDomain", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Domain/UpdateDomain").method(Method.PUT).requestBuilder(UpdateDomainRequest::builder).basePath("/20230401").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Domain.class, UpdateDomainResponse.Builder::domain).handleResponseHeaderString("opc-request-id", UpdateDomainResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateDomainResponse.Builder::etag).callSync();
    }

    @Override
    public DomainWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DomainPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DomainClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DomainClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DomainClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DomainClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DomainClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DomainClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

