/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.tenantmanagercontrolplane.Governance;
import com.oracle.bmc.tenantmanagercontrolplane.requests.AddGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.RemoveGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.AddGovernanceResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.RemoveGovernanceResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceClient
extends BaseSyncClient
implements Governance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GOVERNANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GovernanceClient.class);

    GovernanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddGovernanceResponse addGovernance(AddGovernanceRequest request) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return (AddGovernanceResponse)this.clientCall(request, AddGovernanceResponse::builder).logger(LOG, "addGovernance").serviceDetails("Governance", "AddGovernance", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/OrganizationTenancy/AddGovernance").method(Method.POST).requestBuilder(AddGovernanceRequest::builder).basePath("/20230401").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).appendPathParam("tenancies").appendPathParam(request.getOrganizationTenancyId()).appendPathParam("actions").appendPathParam("addGovernance").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", AddGovernanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddGovernanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RemoveGovernanceResponse removeGovernance(RemoveGovernanceRequest request) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return (RemoveGovernanceResponse)this.clientCall(request, RemoveGovernanceResponse::builder).logger(LOG, "removeGovernance").serviceDetails("Governance", "RemoveGovernance", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/OrganizationTenancy/RemoveGovernance").method(Method.POST).requestBuilder(RemoveGovernanceRequest::builder).basePath("/20230401").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).appendPathParam("tenancies").appendPathParam(request.getOrganizationTenancyId()).appendPathParam("actions").appendPathParam("removeGovernance").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", RemoveGovernanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RemoveGovernanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Deprecated
    public GovernanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GovernanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GovernanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GovernanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GovernanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public GovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public GovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public GovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GovernanceClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public GovernanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GovernanceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

