/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.tenantmanagercontrolplane.Link;
import com.oracle.bmc.tenantmanagercontrolplane.LinkPaginators;
import com.oracle.bmc.tenantmanagercontrolplane.LinkWaiters;
import com.oracle.bmc.tenantmanagercontrolplane.model.LinkCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteLinkRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetLinkRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListLinksRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteLinkResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetLinkResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListLinksResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkClient
extends BaseSyncClient
implements Link {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LINK").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LinkClient.class);
    private final LinkWaiters waiters;
    private final LinkPaginators paginators;

    LinkClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Link-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LinkWaiters(executorService, this);
        this.paginators = new LinkPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public DeleteLinkResponse deleteLink(DeleteLinkRequest request) {
        Validate.notBlank((String)request.getLinkId(), (String)"linkId must not be blank", (Object[])new Object[0]);
        return (DeleteLinkResponse)this.clientCall(request, DeleteLinkResponse::builder).logger(LOG, "deleteLink").serviceDetails("Link", "DeleteLink", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Link/DeleteLink").method(Method.DELETE).requestBuilder(DeleteLinkRequest::builder).basePath("/20230401").appendPathParam("links").appendPathParam(request.getLinkId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteLinkResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteLinkResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetLinkResponse getLink(GetLinkRequest request) {
        Validate.notBlank((String)request.getLinkId(), (String)"linkId must not be blank", (Object[])new Object[0]);
        return (GetLinkResponse)this.clientCall(request, GetLinkResponse::builder).logger(LOG, "getLink").serviceDetails("Link", "GetLink", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Link/GetLink").method(Method.GET).requestBuilder(GetLinkRequest::builder).basePath("/20230401").appendPathParam("links").appendPathParam(request.getLinkId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.tenantmanagercontrolplane.model.Link.class, GetLinkResponse.Builder::link).handleResponseHeaderString("etag", GetLinkResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLinkResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListLinksResponse listLinks(ListLinksRequest request) {
        return (ListLinksResponse)this.clientCall(request, ListLinksResponse::builder).logger(LOG, "listLinks").serviceDetails("Link", "ListLinks", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Link/ListLinks").method(Method.GET).requestBuilder(ListLinksRequest::builder).basePath("/20230401").appendPathParam("links").appendQueryParam("parentTenancyId", (Object)request.getParentTenancyId()).appendQueryParam("childTenancyId", (Object)request.getChildTenancyId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LinkCollection.class, ListLinksResponse.Builder::linkCollection).handleResponseHeaderString("opc-next-page", ListLinksResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLinksResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public LinkWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LinkPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public LinkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LinkClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LinkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LinkClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LinkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LinkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LinkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LinkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LinkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LinkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LinkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LinkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LinkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LinkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LinkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LinkClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LinkClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public LinkClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LinkClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

