/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.tenantmanagercontrolplane.Orders;
import com.oracle.bmc.tenantmanagercontrolplane.model.Order;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ActivateOrderRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrderRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ActivateOrderResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrderResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrdersClient
extends BaseSyncClient
implements Orders {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ORDERS").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OrdersClient.class);

    OrdersClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ActivateOrderResponse activateOrder(ActivateOrderRequest request) {
        Objects.requireNonNull(request.getActivateOrderDetails(), "activateOrderDetails is required");
        Validate.notBlank((String)request.getActivationToken(), (String)"activationToken must not be blank", (Object[])new Object[0]);
        return (ActivateOrderResponse)this.clientCall(request, ActivateOrderResponse::builder).logger(LOG, "activateOrder").serviceDetails("Orders", "ActivateOrder", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Order/ActivateOrder").method(Method.POST).requestBuilder(ActivateOrderRequest::builder).basePath("/20230401").appendPathParam("orders").appendPathParam(request.getActivationToken()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ActivateOrderResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ActivateOrderResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetOrderResponse getOrder(GetOrderRequest request) {
        Validate.notBlank((String)request.getActivationToken(), (String)"activationToken must not be blank", (Object[])new Object[0]);
        return (GetOrderResponse)this.clientCall(request, GetOrderResponse::builder).logger(LOG, "getOrder").serviceDetails("Orders", "GetOrder", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Order/GetOrder").method(Method.GET).requestBuilder(GetOrderRequest::builder).basePath("/20230401").appendPathParam("orders").appendPathParam(request.getActivationToken()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Order.class, GetOrderResponse.Builder::order).handleResponseHeaderString("opc-request-id", GetOrderResponse.Builder::opcRequestId).callSync();
    }

    @Deprecated
    public OrdersClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OrdersClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrdersClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OrdersClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrdersClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OrdersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrdersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OrdersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OrdersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OrdersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OrdersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OrdersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OrdersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OrdersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OrdersClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OrdersClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OrdersClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

