/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.OrganizationAsync;
import com.oracle.bmc.tenantmanagercontrolplane.model.Organization;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationTenancy;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationTenancyCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ApproveOrganizationTenancyForTransferRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateChildTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrganizationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListOrganizationTenanciesRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListOrganizationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.RestoreOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UnapproveOrganizationTenancyForTransferRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateOrganizationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ApproveOrganizationTenancyForTransferResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateChildTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrganizationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListOrganizationTenanciesResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListOrganizationsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.RestoreOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UnapproveOrganizationTenancyForTransferResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateOrganizationResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationAsyncClient
extends BaseAsyncClient
implements OrganizationAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ORGANIZATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OrganizationAsyncClient.class);

    OrganizationAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ApproveOrganizationTenancyForTransferResponse> approveOrganizationTenancyForTransfer(ApproveOrganizationTenancyForTransferRequest request, AsyncHandler<ApproveOrganizationTenancyForTransferRequest, ApproveOrganizationTenancyForTransferResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ApproveOrganizationTenancyForTransferResponse::builder).logger(LOG, "approveOrganizationTenancyForTransfer").serviceDetails("Organization", "ApproveOrganizationTenancyForTransfer", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/OrganizationTenancy/ApproveOrganizationTenancyForTransfer").method(Method.POST).requestBuilder(ApproveOrganizationTenancyForTransferRequest::builder).basePath("/20230401").appendPathParam("organizationTenancies").appendPathParam(request.getOrganizationTenancyId()).appendPathParam("actions").appendPathParam("approveForTransfer").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationTenancy.class, ApproveOrganizationTenancyForTransferResponse.Builder::organizationTenancy).handleResponseHeaderString("opc-request-id", ApproveOrganizationTenancyForTransferResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ApproveOrganizationTenancyForTransferResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateChildTenancyResponse> createChildTenancy(CreateChildTenancyRequest request, AsyncHandler<CreateChildTenancyRequest, CreateChildTenancyResponse> handler) {
        Objects.requireNonNull(request.getCreateChildTenancyDetails(), "createChildTenancyDetails is required");
        return this.clientCall(request, CreateChildTenancyResponse::builder).logger(LOG, "createChildTenancy").serviceDetails("Organization", "CreateChildTenancy", "").method(Method.POST).requestBuilder(CreateChildTenancyRequest::builder).basePath("/20230401").appendPathParam("childTenancies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateChildTenancyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateChildTenancyResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOrganizationTenancyResponse> deleteOrganizationTenancy(DeleteOrganizationTenancyRequest request, AsyncHandler<DeleteOrganizationTenancyRequest, DeleteOrganizationTenancyResponse> handler) {
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOrganizationTenancyResponse::builder).logger(LOG, "deleteOrganizationTenancy").serviceDetails("Organization", "DeleteOrganizationTenancy", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/OrganizationTenancy/DeleteOrganizationTenancy").method(Method.DELETE).requestBuilder(DeleteOrganizationTenancyRequest::builder).basePath("/20230401").appendPathParam("organizationTenancies").appendPathParam(request.getOrganizationTenancyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteOrganizationTenancyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteOrganizationTenancyResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOrganizationResponse> getOrganization(GetOrganizationRequest request, AsyncHandler<GetOrganizationRequest, GetOrganizationResponse> handler) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOrganizationResponse::builder).logger(LOG, "getOrganization").serviceDetails("Organization", "GetOrganization", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Organization/GetOrganization").method(Method.GET).requestBuilder(GetOrganizationRequest::builder).basePath("/20230401").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Organization.class, GetOrganizationResponse.Builder::organization).handleResponseHeaderString("etag", GetOrganizationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOrganizationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOrganizationTenancyResponse> getOrganizationTenancy(GetOrganizationTenancyRequest request, AsyncHandler<GetOrganizationTenancyRequest, GetOrganizationTenancyResponse> handler) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTenancyId(), (String)"tenancyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOrganizationTenancyResponse::builder).logger(LOG, "getOrganizationTenancy").serviceDetails("Organization", "GetOrganizationTenancy", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/OrganizationTenancy/GetOrganizationTenancy").method(Method.GET).requestBuilder(GetOrganizationTenancyRequest::builder).basePath("/20230401").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).appendPathParam("tenancies").appendPathParam(request.getTenancyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationTenancy.class, GetOrganizationTenancyResponse.Builder::organizationTenancy).handleResponseHeaderString("etag", GetOrganizationTenancyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOrganizationTenancyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListOrganizationTenanciesResponse> listOrganizationTenancies(ListOrganizationTenanciesRequest request, AsyncHandler<ListOrganizationTenanciesRequest, ListOrganizationTenanciesResponse> handler) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListOrganizationTenanciesResponse::builder).logger(LOG, "listOrganizationTenancies").serviceDetails("Organization", "ListOrganizationTenancies", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Organization/ListOrganizationTenancies").method(Method.GET).requestBuilder(ListOrganizationTenanciesRequest::builder).basePath("/20230401").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).appendPathParam("tenancies").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationTenancyCollection.class, ListOrganizationTenanciesResponse.Builder::organizationTenancyCollection).handleResponseHeaderString("opc-next-page", ListOrganizationTenanciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListOrganizationTenanciesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListOrganizationsResponse> listOrganizations(ListOrganizationsRequest request, AsyncHandler<ListOrganizationsRequest, ListOrganizationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListOrganizationsResponse::builder).logger(LOG, "listOrganizations").serviceDetails("Organization", "ListOrganizations", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Organization/ListOrganizations").method(Method.GET).requestBuilder(ListOrganizationsRequest::builder).basePath("/20230401").appendPathParam("organizations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationCollection.class, ListOrganizationsResponse.Builder::organizationCollection).handleResponseHeaderString("opc-next-page", ListOrganizationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListOrganizationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RestoreOrganizationTenancyResponse> restoreOrganizationTenancy(RestoreOrganizationTenancyRequest request, AsyncHandler<RestoreOrganizationTenancyRequest, RestoreOrganizationTenancyResponse> handler) {
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RestoreOrganizationTenancyResponse::builder).logger(LOG, "restoreOrganizationTenancy").serviceDetails("Organization", "RestoreOrganizationTenancy", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/OrganizationTenancy/RestoreOrganizationTenancy").method(Method.POST).requestBuilder(RestoreOrganizationTenancyRequest::builder).basePath("/20230401").appendPathParam("organizationTenancies").appendPathParam(request.getOrganizationTenancyId()).appendPathParam("actions").appendPathParam("restore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", RestoreOrganizationTenancyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestoreOrganizationTenancyResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UnapproveOrganizationTenancyForTransferResponse> unapproveOrganizationTenancyForTransfer(UnapproveOrganizationTenancyForTransferRequest request, AsyncHandler<UnapproveOrganizationTenancyForTransferRequest, UnapproveOrganizationTenancyForTransferResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UnapproveOrganizationTenancyForTransferResponse::builder).logger(LOG, "unapproveOrganizationTenancyForTransfer").serviceDetails("Organization", "UnapproveOrganizationTenancyForTransfer", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/OrganizationTenancy/UnapproveOrganizationTenancyForTransfer").method(Method.POST).requestBuilder(UnapproveOrganizationTenancyForTransferRequest::builder).basePath("/20230401").appendPathParam("organizationTenancies").appendPathParam(request.getOrganizationTenancyId()).appendPathParam("actions").appendPathParam("unapproveForTransfer").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationTenancy.class, UnapproveOrganizationTenancyForTransferResponse.Builder::organizationTenancy).handleResponseHeaderString("opc-request-id", UnapproveOrganizationTenancyForTransferResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UnapproveOrganizationTenancyForTransferResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateOrganizationResponse> updateOrganization(UpdateOrganizationRequest request, AsyncHandler<UpdateOrganizationRequest, UpdateOrganizationResponse> handler) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOrganizationDetails(), "updateOrganizationDetails is required");
        return this.clientCall(request, UpdateOrganizationResponse::builder).logger(LOG, "updateOrganization").serviceDetails("Organization", "UpdateOrganization", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Organization/UpdateOrganization").method(Method.PUT).requestBuilder(UpdateOrganizationRequest::builder).basePath("/20230401").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateOrganizationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateOrganizationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public OrganizationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OrganizationAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OrganizationAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OrganizationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OrganizationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OrganizationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OrganizationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OrganizationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OrganizationAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OrganizationAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OrganizationAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

