/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitation;
import com.oracle.bmc.tenantmanagercontrolplane.model.RecipientInvitationSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListRecipientInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListRecipientInvitationsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class RecipientInvitationPaginators {
    private final RecipientInvitation client;

    public RecipientInvitationPaginators(RecipientInvitation client) {
        this.client = client;
    }

    public Iterable<ListRecipientInvitationsResponse> listRecipientInvitationsResponseIterator(final ListRecipientInvitationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRecipientInvitationsRequest.Builder>(){

            @Override
            public ListRecipientInvitationsRequest.Builder get() {
                return ListRecipientInvitationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecipientInvitationsResponse, String>(){

            @Override
            public String apply(ListRecipientInvitationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecipientInvitationsRequest.Builder>, ListRecipientInvitationsRequest>(){

            @Override
            public ListRecipientInvitationsRequest apply(RequestBuilderAndToken<ListRecipientInvitationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecipientInvitationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecipientInvitationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecipientInvitationsRequest, ListRecipientInvitationsResponse>(){

            @Override
            public ListRecipientInvitationsResponse apply(ListRecipientInvitationsRequest request) {
                return RecipientInvitationPaginators.this.client.listRecipientInvitations(request);
            }
        });
    }

    public Iterable<RecipientInvitationSummary> listRecipientInvitationsRecordIterator(final ListRecipientInvitationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRecipientInvitationsRequest.Builder>(){

            @Override
            public ListRecipientInvitationsRequest.Builder get() {
                return ListRecipientInvitationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecipientInvitationsResponse, String>(){

            @Override
            public String apply(ListRecipientInvitationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecipientInvitationsRequest.Builder>, ListRecipientInvitationsRequest>(){

            @Override
            public ListRecipientInvitationsRequest apply(RequestBuilderAndToken<ListRecipientInvitationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecipientInvitationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecipientInvitationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecipientInvitationsRequest, ListRecipientInvitationsResponse>(){

            @Override
            public ListRecipientInvitationsResponse apply(ListRecipientInvitationsRequest request) {
                return RecipientInvitationPaginators.this.client.listRecipientInvitations(request);
            }
        }, (Function)new Function<ListRecipientInvitationsResponse, List<RecipientInvitationSummary>>(){

            @Override
            public List<RecipientInvitationSummary> apply(ListRecipientInvitationsResponse response) {
                return response.getRecipientInvitationCollection().getItems();
            }
        });
    }
}

