/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.SenderInvitationAsync;
import com.oracle.bmc.tenantmanagercontrolplane.model.SenderInvitation;
import com.oracle.bmc.tenantmanagercontrolplane.model.SenderInvitationCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CancelSenderInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateSenderInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetSenderInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSenderInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateSenderInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CancelSenderInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateSenderInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetSenderInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSenderInvitationsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateSenderInvitationResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderInvitationAsyncClient
extends BaseAsyncClient
implements SenderInvitationAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SENDERINVITATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SenderInvitationAsyncClient.class);

    SenderInvitationAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelSenderInvitationResponse> cancelSenderInvitation(CancelSenderInvitationRequest request, AsyncHandler<CancelSenderInvitationRequest, CancelSenderInvitationResponse> handler) {
        Validate.notBlank((String)request.getSenderInvitationId(), (String)"senderInvitationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelSenderInvitationResponse::builder).logger(LOG, "cancelSenderInvitation").serviceDetails("SenderInvitation", "CancelSenderInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SenderInvitation/CancelSenderInvitation").method(Method.POST).requestBuilder(CancelSenderInvitationRequest::builder).basePath("/20230401").appendPathParam("senderInvitations").appendPathParam(request.getSenderInvitationId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelSenderInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CancelSenderInvitationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSenderInvitationResponse> createSenderInvitation(CreateSenderInvitationRequest request, AsyncHandler<CreateSenderInvitationRequest, CreateSenderInvitationResponse> handler) {
        Objects.requireNonNull(request.getCreateSenderInvitationDetails(), "createSenderInvitationDetails is required");
        return this.clientCall(request, CreateSenderInvitationResponse::builder).logger(LOG, "createSenderInvitation").serviceDetails("SenderInvitation", "CreateSenderInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SenderInvitation/CreateSenderInvitation").method(Method.POST).requestBuilder(CreateSenderInvitationRequest::builder).basePath("/20230401").appendPathParam("senderInvitations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SenderInvitation.class, CreateSenderInvitationResponse.Builder::senderInvitation).handleResponseHeaderString("opc-request-id", CreateSenderInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateSenderInvitationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateSenderInvitationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetSenderInvitationResponse> getSenderInvitation(GetSenderInvitationRequest request, AsyncHandler<GetSenderInvitationRequest, GetSenderInvitationResponse> handler) {
        Validate.notBlank((String)request.getSenderInvitationId(), (String)"senderInvitationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSenderInvitationResponse::builder).logger(LOG, "getSenderInvitation").serviceDetails("SenderInvitation", "GetSenderInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SenderInvitation/GetSenderInvitation").method(Method.GET).requestBuilder(GetSenderInvitationRequest::builder).basePath("/20230401").appendPathParam("senderInvitations").appendPathParam(request.getSenderInvitationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SenderInvitation.class, GetSenderInvitationResponse.Builder::senderInvitation).handleResponseHeaderString("etag", GetSenderInvitationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSenderInvitationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSenderInvitationsResponse> listSenderInvitations(ListSenderInvitationsRequest request, AsyncHandler<ListSenderInvitationsRequest, ListSenderInvitationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSenderInvitationsResponse::builder).logger(LOG, "listSenderInvitations").serviceDetails("SenderInvitation", "ListSenderInvitations", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SenderInvitation/ListSenderInvitations").method(Method.GET).requestBuilder(ListSenderInvitationsRequest::builder).basePath("/20230401").appendPathParam("senderInvitations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("recipientTenancyId", (Object)request.getRecipientTenancyId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SenderInvitationCollection.class, ListSenderInvitationsResponse.Builder::senderInvitationCollection).handleResponseHeaderString("opc-next-page", ListSenderInvitationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSenderInvitationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSenderInvitationResponse> updateSenderInvitation(UpdateSenderInvitationRequest request, AsyncHandler<UpdateSenderInvitationRequest, UpdateSenderInvitationResponse> handler) {
        Validate.notBlank((String)request.getSenderInvitationId(), (String)"senderInvitationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSenderInvitationDetails(), "updateSenderInvitationDetails is required");
        return this.clientCall(request, UpdateSenderInvitationResponse::builder).logger(LOG, "updateSenderInvitation").serviceDetails("SenderInvitation", "UpdateSenderInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SenderInvitation/UpdateSenderInvitation").method(Method.PUT).requestBuilder(UpdateSenderInvitationRequest::builder).basePath("/20230401").appendPathParam("senderInvitations").appendPathParam(request.getSenderInvitationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SenderInvitation.class, UpdateSenderInvitationResponse.Builder::senderInvitation).handleResponseHeaderString("opc-request-id", UpdateSenderInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateSenderInvitationResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public SenderInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SenderInvitationAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SenderInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SenderInvitationAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SenderInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SenderInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SenderInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SenderInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SenderInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SenderInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SenderInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SenderInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SenderInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SenderInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SenderInvitationAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SenderInvitationAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SenderInvitationAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

