/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.tenantmanagercontrolplane.SubscriptionPaginators;
import com.oracle.bmc.tenantmanagercontrolplane.SubscriptionWaiters;
import com.oracle.bmc.tenantmanagercontrolplane.model.AssignedSubscription;
import com.oracle.bmc.tenantmanagercontrolplane.model.AssignedSubscriptionCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.AssignedSubscriptionLineItemCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.AvailableRegionCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.Subscription;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionLineItemCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionMapping;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionMappingCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetAssignedSubscriptionRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetSubscriptionRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAssignedSubscriptionLineItemsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAssignedSubscriptionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAvailableRegionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionLineItemsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionMappingsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetAssignedSubscriptionResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetSubscriptionResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAssignedSubscriptionLineItemsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAssignedSubscriptionsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAvailableRegionsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionLineItemsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionMappingsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionClient
extends BaseSyncClient
implements com.oracle.bmc.tenantmanagercontrolplane.Subscription {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SUBSCRIPTION").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionClient.class);
    private final SubscriptionWaiters waiters;
    private final SubscriptionPaginators paginators;

    SubscriptionClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Subscription-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new SubscriptionWaiters(executorService, this);
        this.paginators = new SubscriptionPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateSubscriptionMappingResponse createSubscriptionMapping(CreateSubscriptionMappingRequest request) {
        Objects.requireNonNull(request.getCreateSubscriptionMappingDetails(), "createSubscriptionMappingDetails is required");
        return (CreateSubscriptionMappingResponse)this.clientCall(request, CreateSubscriptionMappingResponse::builder).logger(LOG, "createSubscriptionMapping").serviceDetails("Subscription", "CreateSubscriptionMapping", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SubscriptionMapping/CreateSubscriptionMapping").method(Method.POST).requestBuilder(CreateSubscriptionMappingRequest::builder).basePath("/20230401").appendPathParam("subscriptionMappings").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SubscriptionMapping.class, CreateSubscriptionMappingResponse.Builder::subscriptionMapping).handleResponseHeaderString("opc-request-id", CreateSubscriptionMappingResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateSubscriptionMappingResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateSubscriptionMappingResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteSubscriptionMappingResponse deleteSubscriptionMapping(DeleteSubscriptionMappingRequest request) {
        Validate.notBlank((String)request.getSubscriptionMappingId(), (String)"subscriptionMappingId must not be blank", (Object[])new Object[0]);
        return (DeleteSubscriptionMappingResponse)this.clientCall(request, DeleteSubscriptionMappingResponse::builder).logger(LOG, "deleteSubscriptionMapping").serviceDetails("Subscription", "DeleteSubscriptionMapping", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SubscriptionMapping/DeleteSubscriptionMapping").method(Method.DELETE).requestBuilder(DeleteSubscriptionMappingRequest::builder).basePath("/20230401").appendPathParam("subscriptionMappings").appendPathParam(request.getSubscriptionMappingId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSubscriptionMappingResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAssignedSubscriptionResponse getAssignedSubscription(GetAssignedSubscriptionRequest request) {
        Validate.notBlank((String)request.getAssignedSubscriptionId(), (String)"assignedSubscriptionId must not be blank", (Object[])new Object[0]);
        return (GetAssignedSubscriptionResponse)this.clientCall(request, GetAssignedSubscriptionResponse::builder).logger(LOG, "getAssignedSubscription").serviceDetails("Subscription", "GetAssignedSubscription", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/AssignedSubscription/GetAssignedSubscription").method(Method.GET).requestBuilder(GetAssignedSubscriptionRequest::builder).basePath("/20230401").appendPathParam("assignedSubscriptions").appendPathParam(request.getAssignedSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssignedSubscription.class, GetAssignedSubscriptionResponse.Builder::assignedSubscription).handleResponseHeaderString("opc-request-id", GetAssignedSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAssignedSubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public GetSubscriptionResponse getSubscription(GetSubscriptionRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return (GetSubscriptionResponse)this.clientCall(request, GetSubscriptionResponse::builder).logger(LOG, "getSubscription").serviceDetails("Subscription", "GetSubscription", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Subscription/GetSubscription").method(Method.GET).requestBuilder(GetSubscriptionRequest::builder).basePath("/20230401").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Subscription.class, GetSubscriptionResponse.Builder::subscription).handleResponseHeaderString("opc-request-id", GetSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public GetSubscriptionMappingResponse getSubscriptionMapping(GetSubscriptionMappingRequest request) {
        Validate.notBlank((String)request.getSubscriptionMappingId(), (String)"subscriptionMappingId must not be blank", (Object[])new Object[0]);
        return (GetSubscriptionMappingResponse)this.clientCall(request, GetSubscriptionMappingResponse::builder).logger(LOG, "getSubscriptionMapping").serviceDetails("Subscription", "GetSubscriptionMapping", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SubscriptionMapping/GetSubscriptionMapping").method(Method.GET).requestBuilder(GetSubscriptionMappingRequest::builder).basePath("/20230401").appendPathParam("subscriptionMappings").appendPathParam(request.getSubscriptionMappingId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriptionMapping.class, GetSubscriptionMappingResponse.Builder::subscriptionMapping).handleResponseHeaderString("opc-request-id", GetSubscriptionMappingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSubscriptionMappingResponse.Builder::etag).callSync();
    }

    @Override
    public ListAssignedSubscriptionLineItemsResponse listAssignedSubscriptionLineItems(ListAssignedSubscriptionLineItemsRequest request) {
        Validate.notBlank((String)request.getAssignedSubscriptionId(), (String)"assignedSubscriptionId must not be blank", (Object[])new Object[0]);
        return (ListAssignedSubscriptionLineItemsResponse)this.clientCall(request, ListAssignedSubscriptionLineItemsResponse::builder).logger(LOG, "listAssignedSubscriptionLineItems").serviceDetails("Subscription", "ListAssignedSubscriptionLineItems", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/AssignedSubscriptionLineItemSummary/ListAssignedSubscriptionLineItems").method(Method.GET).requestBuilder(ListAssignedSubscriptionLineItemsRequest::builder).basePath("/20230401").appendPathParam("assignedSubscriptions").appendPathParam(request.getAssignedSubscriptionId()).appendPathParam("assignedSubscriptionLineItems").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AssignedSubscriptionLineItemCollection.class, ListAssignedSubscriptionLineItemsResponse.Builder::assignedSubscriptionLineItemCollection).handleResponseHeaderString("opc-request-id", ListAssignedSubscriptionLineItemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAssignedSubscriptionLineItemsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListAssignedSubscriptionsResponse listAssignedSubscriptions(ListAssignedSubscriptionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAssignedSubscriptionsResponse)this.clientCall(request, ListAssignedSubscriptionsResponse::builder).logger(LOG, "listAssignedSubscriptions").serviceDetails("Subscription", "ListAssignedSubscriptions", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/AssignedSubscription/ListAssignedSubscriptions").method(Method.GET).requestBuilder(ListAssignedSubscriptionsRequest::builder).basePath("/20230401").appendPathParam("assignedSubscriptions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("entityVersion", (BmcEnum)request.getEntityVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssignedSubscriptionCollection.class, ListAssignedSubscriptionsResponse.Builder::assignedSubscriptionCollection).handleResponseHeaderString("opc-next-page", ListAssignedSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAssignedSubscriptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAvailableRegionsResponse listAvailableRegions(ListAvailableRegionsRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return (ListAvailableRegionsResponse)this.clientCall(request, ListAvailableRegionsResponse::builder).logger(LOG, "listAvailableRegions").serviceDetails("Subscription", "ListAvailableRegions", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Subscription/ListAvailableRegions").method(Method.GET).requestBuilder(ListAvailableRegionsRequest::builder).basePath("/20230401").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("availableRegions").appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AvailableRegionCollection.class, ListAvailableRegionsResponse.Builder::availableRegionCollection).handleResponseHeaderString("opc-next-page", ListAvailableRegionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAvailableRegionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSubscriptionLineItemsResponse listSubscriptionLineItems(ListSubscriptionLineItemsRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return (ListSubscriptionLineItemsResponse)this.clientCall(request, ListSubscriptionLineItemsResponse::builder).logger(LOG, "listSubscriptionLineItems").serviceDetails("Subscription", "ListSubscriptionLineItems", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SubscriptionLineItemSummary/ListSubscriptionLineItems").method(Method.GET).requestBuilder(ListSubscriptionLineItemsRequest::builder).basePath("/20230401").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("subscriptionLineItems").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SubscriptionLineItemCollection.class, ListSubscriptionLineItemsResponse.Builder::subscriptionLineItemCollection).handleResponseHeaderString("opc-request-id", ListSubscriptionLineItemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSubscriptionLineItemsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSubscriptionMappingsResponse listSubscriptionMappings(ListSubscriptionMappingsRequest request) {
        Objects.requireNonNull(request.getSubscriptionId(), "subscriptionId is required");
        return (ListSubscriptionMappingsResponse)this.clientCall(request, ListSubscriptionMappingsResponse::builder).logger(LOG, "listSubscriptionMappings").serviceDetails("Subscription", "ListSubscriptionMappings", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/SubscriptionMapping/ListSubscriptionMappings").method(Method.GET).requestBuilder(ListSubscriptionMappingsRequest::builder).basePath("/20230401").appendPathParam("subscriptionMappings").appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("subscriptionMappingId", (Object)request.getSubscriptionMappingId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriptionMappingCollection.class, ListSubscriptionMappingsResponse.Builder::subscriptionMappingCollection).handleResponseHeaderString("opc-next-page", ListSubscriptionMappingsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSubscriptionMappingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest request) {
        return (ListSubscriptionsResponse)this.clientCall(request, ListSubscriptionsResponse::builder).logger(LOG, "listSubscriptions").serviceDetails("Subscription", "ListSubscriptions", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Subscription/ListSubscriptions").method(Method.GET).requestBuilder(ListSubscriptionsRequest::builder).basePath("/20230401").appendPathParam("subscriptions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("entityVersion", (BmcEnum)request.getEntityVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriptionCollection.class, ListSubscriptionsResponse.Builder::subscriptionCollection).handleResponseHeaderString("opc-next-page", ListSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSubscriptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SubscriptionWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public SubscriptionPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public SubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SubscriptionClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SubscriptionClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SubscriptionClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public SubscriptionClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SubscriptionClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

