/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.tenantmanagercontrolplane.Subscription;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionMapping;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetSubscriptionMappingResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class SubscriptionWaiters {
    private final ExecutorService executorService;
    private final Subscription client;

    public SubscriptionWaiters(ExecutorService executorService, Subscription client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetSubscriptionMappingRequest, GetSubscriptionMappingResponse> forSubscriptionMapping(GetSubscriptionMappingRequest request, SubscriptionMapping.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSubscriptionMapping(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSubscriptionMappingRequest, GetSubscriptionMappingResponse> forSubscriptionMapping(GetSubscriptionMappingRequest request, SubscriptionMapping.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSubscriptionMapping(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSubscriptionMappingRequest, GetSubscriptionMappingResponse> forSubscriptionMapping(GetSubscriptionMappingRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SubscriptionMapping.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSubscriptionMapping(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSubscriptionMappingRequest, GetSubscriptionMappingResponse> forSubscriptionMapping(BmcGenericWaiter waiter, GetSubscriptionMappingRequest request, SubscriptionMapping.LifecycleState ... targetStates) {
        final HashSet<SubscriptionMapping.LifecycleState> targetStatesSet = new HashSet<SubscriptionMapping.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSubscriptionMappingRequest, GetSubscriptionMappingResponse>(){

            @Override
            public GetSubscriptionMappingResponse apply(GetSubscriptionMappingRequest request) {
                return SubscriptionWaiters.this.client.getSubscriptionMapping(request);
            }
        }, (Predicate)new Predicate<GetSubscriptionMappingResponse>(){

            @Override
            public boolean test(GetSubscriptionMappingResponse response) {
                return targetStatesSet.contains((Object)response.getSubscriptionMapping().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SubscriptionMapping.LifecycleState.Deleted)), (Object)request);
    }
}

