/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.tenantmanagercontrolplane.model.BillingModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssignedSubscriptionLineItemSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="productCode")
    private final String productCode;
    @JsonProperty(value="quantity")
    private final Float quantity;
    @JsonProperty(value="billingModel")
    private final BillingModel billingModel;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;

    @Deprecated
    @ConstructorProperties(value={"id", "productCode", "quantity", "billingModel", "timeStarted", "timeEnded"})
    public AssignedSubscriptionLineItemSummary(String id, String productCode, Float quantity, BillingModel billingModel, Date timeStarted, Date timeEnded) {
        this.id = id;
        this.productCode = productCode;
        this.quantity = quantity;
        this.billingModel = billingModel;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public Float getQuantity() {
        return this.quantity;
    }

    public BillingModel getBillingModel() {
        return this.billingModel;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssignedSubscriptionLineItemSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", productCode=").append(String.valueOf(this.productCode));
        sb.append(", quantity=").append(String.valueOf(this.quantity));
        sb.append(", billingModel=").append(String.valueOf((Object)this.billingModel));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssignedSubscriptionLineItemSummary)) {
            return false;
        }
        AssignedSubscriptionLineItemSummary other = (AssignedSubscriptionLineItemSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.productCode, other.productCode) && Objects.equals(this.quantity, other.quantity) && Objects.equals((Object)this.billingModel, (Object)other.billingModel) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.productCode == null ? 43 : this.productCode.hashCode());
        result = result * 59 + (this.quantity == null ? 43 : this.quantity.hashCode());
        result = result * 59 + (this.billingModel == null ? 43 : this.billingModel.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="productCode")
        private String productCode;
        @JsonProperty(value="quantity")
        private Float quantity;
        @JsonProperty(value="billingModel")
        private BillingModel billingModel;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder productCode(String productCode) {
            this.productCode = productCode;
            this.__explicitlySet__.add("productCode");
            return this;
        }

        public Builder quantity(Float quantity) {
            this.quantity = quantity;
            this.__explicitlySet__.add("quantity");
            return this;
        }

        public Builder billingModel(BillingModel billingModel) {
            this.billingModel = billingModel;
            this.__explicitlySet__.add("billingModel");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public AssignedSubscriptionLineItemSummary build() {
            AssignedSubscriptionLineItemSummary model = new AssignedSubscriptionLineItemSummary(this.id, this.productCode, this.quantity, this.billingModel, this.timeStarted, this.timeEnded);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssignedSubscriptionLineItemSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("productCode")) {
                this.productCode(model.getProductCode());
            }
            if (model.wasPropertyExplicitlySet("quantity")) {
                this.quantity(model.getQuantity());
            }
            if (model.wasPropertyExplicitlySet("billingModel")) {
                this.billingModel(model.getBillingModel());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            return this;
        }
    }
}

