/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.tenantmanagercontrolplane.model.ClassicSubscriptionLifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.Promotion;
import com.oracle.bmc.tenantmanagercontrolplane.model.Subscription;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionSku;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityVersion")
@JsonFilter(value="explicitlySetFilter")
public final class ClassicSubscription
extends Subscription {
    @JsonProperty(value="classicSubscriptionId")
    private final String classicSubscriptionId;
    @JsonProperty(value="isClassicSubscription")
    private final Boolean isClassicSubscription;
    @JsonProperty(value="paymentModel")
    private final String paymentModel;
    @JsonProperty(value="regionAssignment")
    private final String regionAssignment;
    @JsonProperty(value="lifecycleState")
    private final ClassicSubscriptionLifecycleState lifecycleState;
    @JsonProperty(value="skus")
    private final List<SubscriptionSku> skus;
    @JsonProperty(value="programType")
    private final String programType;
    @JsonProperty(value="customerCountryCode")
    private final String customerCountryCode;
    @JsonProperty(value="cloudAmountCurrency")
    private final String cloudAmountCurrency;
    @JsonProperty(value="csiNumber")
    private final String csiNumber;
    @JsonProperty(value="subscriptionTier")
    private final String subscriptionTier;
    @JsonProperty(value="isGovernmentSubscription")
    private final Boolean isGovernmentSubscription;
    @JsonProperty(value="promotion")
    private final List<Promotion> promotion;
    @JsonProperty(value="purchaseEntitlementId")
    private final String purchaseEntitlementId;
    @JsonProperty(value="startDate")
    private final Date startDate;
    @JsonProperty(value="endDate")
    private final Date endDate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ClassicSubscription(String id, String compartmentId, String serviceName, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String classicSubscriptionId, Boolean isClassicSubscription, String paymentModel, String regionAssignment, ClassicSubscriptionLifecycleState lifecycleState, List<SubscriptionSku> skus, String programType, String customerCountryCode, String cloudAmountCurrency, String csiNumber, String subscriptionTier, Boolean isGovernmentSubscription, List<Promotion> promotion, String purchaseEntitlementId, Date startDate, Date endDate) {
        super(id, compartmentId, serviceName, timeCreated, timeUpdated, freeformTags, definedTags);
        this.classicSubscriptionId = classicSubscriptionId;
        this.isClassicSubscription = isClassicSubscription;
        this.paymentModel = paymentModel;
        this.regionAssignment = regionAssignment;
        this.lifecycleState = lifecycleState;
        this.skus = skus;
        this.programType = programType;
        this.customerCountryCode = customerCountryCode;
        this.cloudAmountCurrency = cloudAmountCurrency;
        this.csiNumber = csiNumber;
        this.subscriptionTier = subscriptionTier;
        this.isGovernmentSubscription = isGovernmentSubscription;
        this.promotion = promotion;
        this.purchaseEntitlementId = purchaseEntitlementId;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public String getClassicSubscriptionId() {
        return this.classicSubscriptionId;
    }

    public Boolean getIsClassicSubscription() {
        return this.isClassicSubscription;
    }

    public String getPaymentModel() {
        return this.paymentModel;
    }

    public String getRegionAssignment() {
        return this.regionAssignment;
    }

    public ClassicSubscriptionLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<SubscriptionSku> getSkus() {
        return this.skus;
    }

    public String getProgramType() {
        return this.programType;
    }

    public String getCustomerCountryCode() {
        return this.customerCountryCode;
    }

    public String getCloudAmountCurrency() {
        return this.cloudAmountCurrency;
    }

    public String getCsiNumber() {
        return this.csiNumber;
    }

    public String getSubscriptionTier() {
        return this.subscriptionTier;
    }

    public Boolean getIsGovernmentSubscription() {
        return this.isGovernmentSubscription;
    }

    public List<Promotion> getPromotion() {
        return this.promotion;
    }

    public String getPurchaseEntitlementId() {
        return this.purchaseEntitlementId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassicSubscription(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", classicSubscriptionId=").append(String.valueOf(this.classicSubscriptionId));
        sb.append(", isClassicSubscription=").append(String.valueOf(this.isClassicSubscription));
        sb.append(", paymentModel=").append(String.valueOf(this.paymentModel));
        sb.append(", regionAssignment=").append(String.valueOf(this.regionAssignment));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", skus=").append(String.valueOf(this.skus));
        sb.append(", programType=").append(String.valueOf(this.programType));
        sb.append(", customerCountryCode=").append(String.valueOf(this.customerCountryCode));
        sb.append(", cloudAmountCurrency=").append(String.valueOf(this.cloudAmountCurrency));
        sb.append(", csiNumber=").append(String.valueOf(this.csiNumber));
        sb.append(", subscriptionTier=").append(String.valueOf(this.subscriptionTier));
        sb.append(", isGovernmentSubscription=").append(String.valueOf(this.isGovernmentSubscription));
        sb.append(", promotion=").append(String.valueOf(this.promotion));
        sb.append(", purchaseEntitlementId=").append(String.valueOf(this.purchaseEntitlementId));
        sb.append(", startDate=").append(String.valueOf(this.startDate));
        sb.append(", endDate=").append(String.valueOf(this.endDate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassicSubscription)) {
            return false;
        }
        ClassicSubscription other = (ClassicSubscription)((Object)o);
        return Objects.equals(this.classicSubscriptionId, other.classicSubscriptionId) && Objects.equals(this.isClassicSubscription, other.isClassicSubscription) && Objects.equals(this.paymentModel, other.paymentModel) && Objects.equals(this.regionAssignment, other.regionAssignment) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.skus, other.skus) && Objects.equals(this.programType, other.programType) && Objects.equals(this.customerCountryCode, other.customerCountryCode) && Objects.equals(this.cloudAmountCurrency, other.cloudAmountCurrency) && Objects.equals(this.csiNumber, other.csiNumber) && Objects.equals(this.subscriptionTier, other.subscriptionTier) && Objects.equals(this.isGovernmentSubscription, other.isGovernmentSubscription) && Objects.equals(this.promotion, other.promotion) && Objects.equals(this.purchaseEntitlementId, other.purchaseEntitlementId) && Objects.equals(this.startDate, other.startDate) && Objects.equals(this.endDate, other.endDate) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.classicSubscriptionId == null ? 43 : this.classicSubscriptionId.hashCode());
        result = result * 59 + (this.isClassicSubscription == null ? 43 : this.isClassicSubscription.hashCode());
        result = result * 59 + (this.paymentModel == null ? 43 : this.paymentModel.hashCode());
        result = result * 59 + (this.regionAssignment == null ? 43 : this.regionAssignment.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.skus == null ? 43 : this.skus.hashCode());
        result = result * 59 + (this.programType == null ? 43 : this.programType.hashCode());
        result = result * 59 + (this.customerCountryCode == null ? 43 : this.customerCountryCode.hashCode());
        result = result * 59 + (this.cloudAmountCurrency == null ? 43 : this.cloudAmountCurrency.hashCode());
        result = result * 59 + (this.csiNumber == null ? 43 : this.csiNumber.hashCode());
        result = result * 59 + (this.subscriptionTier == null ? 43 : this.subscriptionTier.hashCode());
        result = result * 59 + (this.isGovernmentSubscription == null ? 43 : this.isGovernmentSubscription.hashCode());
        result = result * 59 + (this.promotion == null ? 43 : this.promotion.hashCode());
        result = result * 59 + (this.purchaseEntitlementId == null ? 43 : this.purchaseEntitlementId.hashCode());
        result = result * 59 + (this.startDate == null ? 43 : this.startDate.hashCode());
        result = result * 59 + (this.endDate == null ? 43 : this.endDate.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="classicSubscriptionId")
        private String classicSubscriptionId;
        @JsonProperty(value="isClassicSubscription")
        private Boolean isClassicSubscription;
        @JsonProperty(value="paymentModel")
        private String paymentModel;
        @JsonProperty(value="regionAssignment")
        private String regionAssignment;
        @JsonProperty(value="lifecycleState")
        private ClassicSubscriptionLifecycleState lifecycleState;
        @JsonProperty(value="skus")
        private List<SubscriptionSku> skus;
        @JsonProperty(value="programType")
        private String programType;
        @JsonProperty(value="customerCountryCode")
        private String customerCountryCode;
        @JsonProperty(value="cloudAmountCurrency")
        private String cloudAmountCurrency;
        @JsonProperty(value="csiNumber")
        private String csiNumber;
        @JsonProperty(value="subscriptionTier")
        private String subscriptionTier;
        @JsonProperty(value="isGovernmentSubscription")
        private Boolean isGovernmentSubscription;
        @JsonProperty(value="promotion")
        private List<Promotion> promotion;
        @JsonProperty(value="purchaseEntitlementId")
        private String purchaseEntitlementId;
        @JsonProperty(value="startDate")
        private Date startDate;
        @JsonProperty(value="endDate")
        private Date endDate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder classicSubscriptionId(String classicSubscriptionId) {
            this.classicSubscriptionId = classicSubscriptionId;
            this.__explicitlySet__.add("classicSubscriptionId");
            return this;
        }

        public Builder isClassicSubscription(Boolean isClassicSubscription) {
            this.isClassicSubscription = isClassicSubscription;
            this.__explicitlySet__.add("isClassicSubscription");
            return this;
        }

        public Builder paymentModel(String paymentModel) {
            this.paymentModel = paymentModel;
            this.__explicitlySet__.add("paymentModel");
            return this;
        }

        public Builder regionAssignment(String regionAssignment) {
            this.regionAssignment = regionAssignment;
            this.__explicitlySet__.add("regionAssignment");
            return this;
        }

        public Builder lifecycleState(ClassicSubscriptionLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder skus(List<SubscriptionSku> skus) {
            this.skus = skus;
            this.__explicitlySet__.add("skus");
            return this;
        }

        public Builder programType(String programType) {
            this.programType = programType;
            this.__explicitlySet__.add("programType");
            return this;
        }

        public Builder customerCountryCode(String customerCountryCode) {
            this.customerCountryCode = customerCountryCode;
            this.__explicitlySet__.add("customerCountryCode");
            return this;
        }

        public Builder cloudAmountCurrency(String cloudAmountCurrency) {
            this.cloudAmountCurrency = cloudAmountCurrency;
            this.__explicitlySet__.add("cloudAmountCurrency");
            return this;
        }

        public Builder csiNumber(String csiNumber) {
            this.csiNumber = csiNumber;
            this.__explicitlySet__.add("csiNumber");
            return this;
        }

        public Builder subscriptionTier(String subscriptionTier) {
            this.subscriptionTier = subscriptionTier;
            this.__explicitlySet__.add("subscriptionTier");
            return this;
        }

        public Builder isGovernmentSubscription(Boolean isGovernmentSubscription) {
            this.isGovernmentSubscription = isGovernmentSubscription;
            this.__explicitlySet__.add("isGovernmentSubscription");
            return this;
        }

        public Builder promotion(List<Promotion> promotion) {
            this.promotion = promotion;
            this.__explicitlySet__.add("promotion");
            return this;
        }

        public Builder purchaseEntitlementId(String purchaseEntitlementId) {
            this.purchaseEntitlementId = purchaseEntitlementId;
            this.__explicitlySet__.add("purchaseEntitlementId");
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            this.__explicitlySet__.add("startDate");
            return this;
        }

        public Builder endDate(Date endDate) {
            this.endDate = endDate;
            this.__explicitlySet__.add("endDate");
            return this;
        }

        public ClassicSubscription build() {
            ClassicSubscription model = new ClassicSubscription(this.id, this.compartmentId, this.serviceName, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags, this.classicSubscriptionId, this.isClassicSubscription, this.paymentModel, this.regionAssignment, this.lifecycleState, this.skus, this.programType, this.customerCountryCode, this.cloudAmountCurrency, this.csiNumber, this.subscriptionTier, this.isGovernmentSubscription, this.promotion, this.purchaseEntitlementId, this.startDate, this.endDate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClassicSubscription model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("classicSubscriptionId")) {
                this.classicSubscriptionId(model.getClassicSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("isClassicSubscription")) {
                this.isClassicSubscription(model.getIsClassicSubscription());
            }
            if (model.wasPropertyExplicitlySet("paymentModel")) {
                this.paymentModel(model.getPaymentModel());
            }
            if (model.wasPropertyExplicitlySet("regionAssignment")) {
                this.regionAssignment(model.getRegionAssignment());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("skus")) {
                this.skus(model.getSkus());
            }
            if (model.wasPropertyExplicitlySet("programType")) {
                this.programType(model.getProgramType());
            }
            if (model.wasPropertyExplicitlySet("customerCountryCode")) {
                this.customerCountryCode(model.getCustomerCountryCode());
            }
            if (model.wasPropertyExplicitlySet("cloudAmountCurrency")) {
                this.cloudAmountCurrency(model.getCloudAmountCurrency());
            }
            if (model.wasPropertyExplicitlySet("csiNumber")) {
                this.csiNumber(model.getCsiNumber());
            }
            if (model.wasPropertyExplicitlySet("subscriptionTier")) {
                this.subscriptionTier(model.getSubscriptionTier());
            }
            if (model.wasPropertyExplicitlySet("isGovernmentSubscription")) {
                this.isGovernmentSubscription(model.getIsGovernmentSubscription());
            }
            if (model.wasPropertyExplicitlySet("promotion")) {
                this.promotion(model.getPromotion());
            }
            if (model.wasPropertyExplicitlySet("purchaseEntitlementId")) {
                this.purchaseEntitlementId(model.getPurchaseEntitlementId());
            }
            if (model.wasPropertyExplicitlySet("startDate")) {
                this.startDate(model.getStartDate());
            }
            if (model.wasPropertyExplicitlySet("endDate")) {
                this.endDate(model.getEndDate());
            }
            return this;
        }
    }
}

