/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.tenantmanagercontrolplane.model.GovernanceStatus;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationTenancyLifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationTenancyRole;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OrganizationTenancySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="lifecycleState")
    private final OrganizationTenancyLifecycleState lifecycleState;
    @JsonProperty(value="role")
    private final OrganizationTenancyRole role;
    @JsonProperty(value="timeJoined")
    private final Date timeJoined;
    @JsonProperty(value="timeLeft")
    private final Date timeLeft;
    @JsonProperty(value="isApprovedForTransfer")
    private final Boolean isApprovedForTransfer;
    @JsonProperty(value="governanceStatus")
    private final GovernanceStatus governanceStatus;

    @Deprecated
    @ConstructorProperties(value={"tenancyId", "name", "lifecycleState", "role", "timeJoined", "timeLeft", "isApprovedForTransfer", "governanceStatus"})
    public OrganizationTenancySummary(String tenancyId, String name, OrganizationTenancyLifecycleState lifecycleState, OrganizationTenancyRole role, Date timeJoined, Date timeLeft, Boolean isApprovedForTransfer, GovernanceStatus governanceStatus) {
        this.tenancyId = tenancyId;
        this.name = name;
        this.lifecycleState = lifecycleState;
        this.role = role;
        this.timeJoined = timeJoined;
        this.timeLeft = timeLeft;
        this.isApprovedForTransfer = isApprovedForTransfer;
        this.governanceStatus = governanceStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getName() {
        return this.name;
    }

    public OrganizationTenancyLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public OrganizationTenancyRole getRole() {
        return this.role;
    }

    public Date getTimeJoined() {
        return this.timeJoined;
    }

    public Date getTimeLeft() {
        return this.timeLeft;
    }

    public Boolean getIsApprovedForTransfer() {
        return this.isApprovedForTransfer;
    }

    public GovernanceStatus getGovernanceStatus() {
        return this.governanceStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OrganizationTenancySummary(");
        sb.append("super=").append(super.toString());
        sb.append("tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", timeJoined=").append(String.valueOf(this.timeJoined));
        sb.append(", timeLeft=").append(String.valueOf(this.timeLeft));
        sb.append(", isApprovedForTransfer=").append(String.valueOf(this.isApprovedForTransfer));
        sb.append(", governanceStatus=").append(String.valueOf((Object)this.governanceStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrganizationTenancySummary)) {
            return false;
        }
        OrganizationTenancySummary other = (OrganizationTenancySummary)((Object)o);
        return Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.timeJoined, other.timeJoined) && Objects.equals(this.timeLeft, other.timeLeft) && Objects.equals(this.isApprovedForTransfer, other.isApprovedForTransfer) && Objects.equals((Object)this.governanceStatus, (Object)other.governanceStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.timeJoined == null ? 43 : this.timeJoined.hashCode());
        result = result * 59 + (this.timeLeft == null ? 43 : this.timeLeft.hashCode());
        result = result * 59 + (this.isApprovedForTransfer == null ? 43 : this.isApprovedForTransfer.hashCode());
        result = result * 59 + (this.governanceStatus == null ? 43 : this.governanceStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="lifecycleState")
        private OrganizationTenancyLifecycleState lifecycleState;
        @JsonProperty(value="role")
        private OrganizationTenancyRole role;
        @JsonProperty(value="timeJoined")
        private Date timeJoined;
        @JsonProperty(value="timeLeft")
        private Date timeLeft;
        @JsonProperty(value="isApprovedForTransfer")
        private Boolean isApprovedForTransfer;
        @JsonProperty(value="governanceStatus")
        private GovernanceStatus governanceStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder lifecycleState(OrganizationTenancyLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder role(OrganizationTenancyRole role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder timeJoined(Date timeJoined) {
            this.timeJoined = timeJoined;
            this.__explicitlySet__.add("timeJoined");
            return this;
        }

        public Builder timeLeft(Date timeLeft) {
            this.timeLeft = timeLeft;
            this.__explicitlySet__.add("timeLeft");
            return this;
        }

        public Builder isApprovedForTransfer(Boolean isApprovedForTransfer) {
            this.isApprovedForTransfer = isApprovedForTransfer;
            this.__explicitlySet__.add("isApprovedForTransfer");
            return this;
        }

        public Builder governanceStatus(GovernanceStatus governanceStatus) {
            this.governanceStatus = governanceStatus;
            this.__explicitlySet__.add("governanceStatus");
            return this;
        }

        public OrganizationTenancySummary build() {
            OrganizationTenancySummary model = new OrganizationTenancySummary(this.tenancyId, this.name, this.lifecycleState, this.role, this.timeJoined, this.timeLeft, this.isApprovedForTransfer, this.governanceStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OrganizationTenancySummary model) {
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("timeJoined")) {
                this.timeJoined(model.getTimeJoined());
            }
            if (model.wasPropertyExplicitlySet("timeLeft")) {
                this.timeLeft(model.getTimeLeft());
            }
            if (model.wasPropertyExplicitlySet("isApprovedForTransfer")) {
                this.isApprovedForTransfer(model.getIsApprovedForTransfer());
            }
            if (model.wasPropertyExplicitlySet("governanceStatus")) {
                this.governanceStatus(model.getGovernanceStatus());
            }
            return this;
        }
    }
}

