/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.responses;

import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.tenantmanagercontrolplane.model.Domain;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateDomainResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcWorkRequestId;
    private String etag;
    private Domain domain;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Domain getDomain() {
        return this.domain;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcWorkRequestId", "etag", "domain"})
    private CreateDomainResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcWorkRequestId, String etag, Domain domain) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.etag = etag;
        this.domain = domain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",domain=").append(String.valueOf((Object)this.domain));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDomainResponse)) {
            return false;
        }
        CreateDomainResponse other = (CreateDomainResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.domain, (Object)other.domain);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateDomainResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcWorkRequestId;
        private String etag;
        private Domain domain;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder domain(Domain domain) {
            this.domain = domain;
            return this;
        }

        public Builder copy(CreateDomainResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.etag(o.getEtag());
            this.domain(o.getDomain());
            return this;
        }

        public CreateDomainResponse build() {
            return new CreateDomainResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcWorkRequestId, this.etag, this.domain);
        }
    }
}

