/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.tenantmanagercontrolplane.DomainGovernancePaginators;
import com.oracle.bmc.tenantmanagercontrolplane.DomainGovernanceWaiters;
import com.oracle.bmc.tenantmanagercontrolplane.model.DomainGovernance;
import com.oracle.bmc.tenantmanagercontrolplane.model.DomainGovernanceCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateDomainGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteDomainGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetDomainGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListDomainGovernancesRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateDomainGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateDomainGovernanceResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteDomainGovernanceResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetDomainGovernanceResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListDomainGovernancesResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateDomainGovernanceResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainGovernanceClient
extends BaseSyncClient
implements com.oracle.bmc.tenantmanagercontrolplane.DomainGovernance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DOMAINGOVERNANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DomainGovernanceClient.class);
    private final DomainGovernanceWaiters waiters;
    private final DomainGovernancePaginators paginators;

    DomainGovernanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DomainGovernance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DomainGovernanceWaiters(executorService, this);
        this.paginators = new DomainGovernancePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateDomainGovernanceResponse createDomainGovernance(CreateDomainGovernanceRequest request) {
        Objects.requireNonNull(request.getCreateDomainGovernanceDetails(), "createDomainGovernanceDetails is required");
        return (CreateDomainGovernanceResponse)this.clientCall(request, CreateDomainGovernanceResponse::builder).logger(LOG, "createDomainGovernance").serviceDetails("DomainGovernance", "CreateDomainGovernance", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/DomainGovernance/CreateDomainGovernance").method(Method.POST).requestBuilder(CreateDomainGovernanceRequest::builder).basePath("/20230401").appendPathParam("domainGovernances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DomainGovernance.class, CreateDomainGovernanceResponse.Builder::domainGovernance).handleResponseHeaderString("opc-request-id", CreateDomainGovernanceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateDomainGovernanceResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteDomainGovernanceResponse deleteDomainGovernance(DeleteDomainGovernanceRequest request) {
        Validate.notBlank((String)request.getDomainGovernanceId(), (String)"domainGovernanceId must not be blank", (Object[])new Object[0]);
        return (DeleteDomainGovernanceResponse)this.clientCall(request, DeleteDomainGovernanceResponse::builder).logger(LOG, "deleteDomainGovernance").serviceDetails("DomainGovernance", "DeleteDomainGovernance", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/DomainGovernance/DeleteDomainGovernance").method(Method.DELETE).requestBuilder(DeleteDomainGovernanceRequest::builder).basePath("/20230401").appendPathParam("domainGovernances").appendPathParam(request.getDomainGovernanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDomainGovernanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDomainGovernanceResponse getDomainGovernance(GetDomainGovernanceRequest request) {
        Validate.notBlank((String)request.getDomainGovernanceId(), (String)"domainGovernanceId must not be blank", (Object[])new Object[0]);
        return (GetDomainGovernanceResponse)this.clientCall(request, GetDomainGovernanceResponse::builder).logger(LOG, "getDomainGovernance").serviceDetails("DomainGovernance", "GetDomainGovernance", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/DomainGovernance/GetDomainGovernance").method(Method.GET).requestBuilder(GetDomainGovernanceRequest::builder).basePath("/20230401").appendPathParam("domainGovernances").appendPathParam(request.getDomainGovernanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DomainGovernance.class, GetDomainGovernanceResponse.Builder::domainGovernance).handleResponseHeaderString("etag", GetDomainGovernanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDomainGovernanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDomainGovernancesResponse listDomainGovernances(ListDomainGovernancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDomainGovernancesResponse)this.clientCall(request, ListDomainGovernancesResponse::builder).logger(LOG, "listDomainGovernances").serviceDetails("DomainGovernance", "ListDomainGovernances", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/DomainGovernance/ListDomainGovernances").method(Method.GET).requestBuilder(ListDomainGovernancesRequest::builder).basePath("/20230401").appendPathParam("domainGovernances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("domainId", (Object)request.getDomainId()).appendQueryParam("domainGovernanceId", (Object)request.getDomainGovernanceId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DomainGovernanceCollection.class, ListDomainGovernancesResponse.Builder::domainGovernanceCollection).handleResponseHeaderString("opc-next-page", ListDomainGovernancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDomainGovernancesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDomainGovernanceResponse updateDomainGovernance(UpdateDomainGovernanceRequest request) {
        Validate.notBlank((String)request.getDomainGovernanceId(), (String)"domainGovernanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDomainGovernanceDetails(), "updateDomainGovernanceDetails is required");
        return (UpdateDomainGovernanceResponse)this.clientCall(request, UpdateDomainGovernanceResponse::builder).logger(LOG, "updateDomainGovernance").serviceDetails("DomainGovernance", "UpdateDomainGovernance", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/DomainGovernance/UpdateDomainGovernance").method(Method.PUT).requestBuilder(UpdateDomainGovernanceRequest::builder).basePath("/20230401").appendPathParam("domainGovernances").appendPathParam(request.getDomainGovernanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DomainGovernance.class, UpdateDomainGovernanceResponse.Builder::domainGovernance).handleResponseHeaderString("opc-request-id", UpdateDomainGovernanceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateDomainGovernanceResponse.Builder::etag).callSync();
    }

    @Override
    public DomainGovernanceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DomainGovernancePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DomainGovernanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DomainGovernanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainGovernanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DomainGovernanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainGovernanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DomainGovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainGovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DomainGovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainGovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DomainGovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainGovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DomainGovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainGovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DomainGovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DomainGovernanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DomainGovernanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DomainGovernanceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DomainGovernanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DomainGovernanceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

