/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.Domain;
import com.oracle.bmc.tenantmanagercontrolplane.model.DomainSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListDomainsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListDomainsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DomainPaginators {
    private final Domain client;

    public DomainPaginators(Domain client) {
        this.client = client;
    }

    public Iterable<ListDomainsResponse> listDomainsResponseIterator(final ListDomainsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDomainsRequest.Builder>(){

            @Override
            public ListDomainsRequest.Builder get() {
                return ListDomainsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDomainsResponse, String>(){

            @Override
            public String apply(ListDomainsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDomainsRequest.Builder>, ListDomainsRequest>(){

            @Override
            public ListDomainsRequest apply(RequestBuilderAndToken<ListDomainsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDomainsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDomainsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDomainsRequest, ListDomainsResponse>(){

            @Override
            public ListDomainsResponse apply(ListDomainsRequest request) {
                return DomainPaginators.this.client.listDomains(request);
            }
        });
    }

    public Iterable<DomainSummary> listDomainsRecordIterator(final ListDomainsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDomainsRequest.Builder>(){

            @Override
            public ListDomainsRequest.Builder get() {
                return ListDomainsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDomainsResponse, String>(){

            @Override
            public String apply(ListDomainsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDomainsRequest.Builder>, ListDomainsRequest>(){

            @Override
            public ListDomainsRequest apply(RequestBuilderAndToken<ListDomainsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDomainsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDomainsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDomainsRequest, ListDomainsResponse>(){

            @Override
            public ListDomainsResponse apply(ListDomainsRequest request) {
                return DomainPaginators.this.client.listDomains(request);
            }
        }, (Function)new Function<ListDomainsResponse, List<DomainSummary>>(){

            @Override
            public List<DomainSummary> apply(ListDomainsResponse response) {
                return response.getDomainCollection().getItems();
            }
        });
    }
}

