/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.LinkAsync;
import com.oracle.bmc.tenantmanagercontrolplane.model.Link;
import com.oracle.bmc.tenantmanagercontrolplane.model.LinkCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteLinkRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetLinkRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListLinksRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteLinkResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetLinkResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListLinksResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkAsyncClient
extends BaseAsyncClient
implements LinkAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LINK").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LinkAsyncClient.class);

    LinkAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<DeleteLinkResponse> deleteLink(DeleteLinkRequest request, AsyncHandler<DeleteLinkRequest, DeleteLinkResponse> handler) {
        Validate.notBlank((String)request.getLinkId(), (String)"linkId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteLinkResponse::builder).logger(LOG, "deleteLink").serviceDetails("Link", "DeleteLink", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Link/DeleteLink").method(Method.DELETE).requestBuilder(DeleteLinkRequest::builder).basePath("/20230401").appendPathParam("links").appendPathParam(request.getLinkId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteLinkResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteLinkResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetLinkResponse> getLink(GetLinkRequest request, AsyncHandler<GetLinkRequest, GetLinkResponse> handler) {
        Validate.notBlank((String)request.getLinkId(), (String)"linkId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetLinkResponse::builder).logger(LOG, "getLink").serviceDetails("Link", "GetLink", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Link/GetLink").method(Method.GET).requestBuilder(GetLinkRequest::builder).basePath("/20230401").appendPathParam("links").appendPathParam(request.getLinkId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Link.class, GetLinkResponse.Builder::link).handleResponseHeaderString("etag", GetLinkResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLinkResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListLinksResponse> listLinks(ListLinksRequest request, AsyncHandler<ListLinksRequest, ListLinksResponse> handler) {
        return this.clientCall(request, ListLinksResponse::builder).logger(LOG, "listLinks").serviceDetails("Link", "ListLinks", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/Link/ListLinks").method(Method.GET).requestBuilder(ListLinksRequest::builder).basePath("/20230401").appendPathParam("links").appendQueryParam("parentTenancyId", (Object)request.getParentTenancyId()).appendQueryParam("childTenancyId", (Object)request.getChildTenancyId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LinkCollection.class, ListLinksResponse.Builder::linkCollection).handleResponseHeaderString("opc-next-page", ListLinksResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLinksResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public LinkAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LinkAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LinkAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LinkAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LinkAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LinkAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LinkAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LinkAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public LinkAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LinkAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public LinkAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LinkAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public LinkAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LinkAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LinkAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LinkAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LinkAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

