/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.tenantmanagercontrolplane.Organization;
import com.oracle.bmc.tenantmanagercontrolplane.model.Organization;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationTenancyLifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrganizationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrganizationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrganizationTenancyResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OrganizationWaiters {
    private final ExecutorService executorService;
    private final Organization client;

    public OrganizationWaiters(ExecutorService executorService, Organization client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOrganizationRequest, GetOrganizationResponse> forOrganization(GetOrganizationRequest request, Organization.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOrganization(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOrganizationRequest, GetOrganizationResponse> forOrganization(GetOrganizationRequest request, Organization.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOrganization(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOrganizationRequest, GetOrganizationResponse> forOrganization(GetOrganizationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Organization.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOrganization(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOrganizationRequest, GetOrganizationResponse> forOrganization(BmcGenericWaiter waiter, GetOrganizationRequest request, Organization.LifecycleState ... targetStates) {
        final HashSet<Organization.LifecycleState> targetStatesSet = new HashSet<Organization.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOrganizationRequest, GetOrganizationResponse>(){

            @Override
            public GetOrganizationResponse apply(GetOrganizationRequest request) {
                return OrganizationWaiters.this.client.getOrganization(request);
            }
        }, (Predicate)new Predicate<GetOrganizationResponse>(){

            @Override
            public boolean test(GetOrganizationResponse response) {
                return targetStatesSet.contains((Object)response.getOrganization().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Organization.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOrganizationTenancyRequest, GetOrganizationTenancyResponse> forOrganizationTenancy(GetOrganizationTenancyRequest request, OrganizationTenancyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOrganizationTenancy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOrganizationTenancyRequest, GetOrganizationTenancyResponse> forOrganizationTenancy(GetOrganizationTenancyRequest request, OrganizationTenancyLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOrganizationTenancy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOrganizationTenancyRequest, GetOrganizationTenancyResponse> forOrganizationTenancy(GetOrganizationTenancyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OrganizationTenancyLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOrganizationTenancy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOrganizationTenancyRequest, GetOrganizationTenancyResponse> forOrganizationTenancy(BmcGenericWaiter waiter, GetOrganizationTenancyRequest request, OrganizationTenancyLifecycleState ... targetStates) {
        final HashSet<OrganizationTenancyLifecycleState> targetStatesSet = new HashSet<OrganizationTenancyLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOrganizationTenancyRequest, GetOrganizationTenancyResponse>(){

            @Override
            public GetOrganizationTenancyResponse apply(GetOrganizationTenancyRequest request) {
                return OrganizationWaiters.this.client.getOrganizationTenancy(request);
            }
        }, (Predicate)new Predicate<GetOrganizationTenancyResponse>(){

            @Override
            public boolean test(GetOrganizationTenancyResponse response) {
                return targetStatesSet.contains((Object)response.getOrganizationTenancy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OrganizationTenancyLifecycleState.Deleted)), (Object)request);
    }
}

