/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitationAsync;
import com.oracle.bmc.tenantmanagercontrolplane.model.RecipientInvitation;
import com.oracle.bmc.tenantmanagercontrolplane.model.RecipientInvitationCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.AcceptRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.IgnoreRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListRecipientInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.AcceptRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.IgnoreRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListRecipientInvitationsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateRecipientInvitationResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientInvitationAsyncClient
extends BaseAsyncClient
implements RecipientInvitationAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RECIPIENTINVITATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RecipientInvitationAsyncClient.class);

    RecipientInvitationAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AcceptRecipientInvitationResponse> acceptRecipientInvitation(AcceptRecipientInvitationRequest request, AsyncHandler<AcceptRecipientInvitationRequest, AcceptRecipientInvitationResponse> handler) {
        Validate.notBlank((String)request.getRecipientInvitationId(), (String)"recipientInvitationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, AcceptRecipientInvitationResponse::builder).logger(LOG, "acceptRecipientInvitation").serviceDetails("RecipientInvitation", "AcceptRecipientInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/RecipientInvitation/AcceptRecipientInvitation").method(Method.POST).requestBuilder(AcceptRecipientInvitationRequest::builder).basePath("/20230401").appendPathParam("recipientInvitations").appendPathParam(request.getRecipientInvitationId()).appendPathParam("actions").appendPathParam("accept").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", AcceptRecipientInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AcceptRecipientInvitationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRecipientInvitationResponse> getRecipientInvitation(GetRecipientInvitationRequest request, AsyncHandler<GetRecipientInvitationRequest, GetRecipientInvitationResponse> handler) {
        Validate.notBlank((String)request.getRecipientInvitationId(), (String)"recipientInvitationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRecipientInvitationResponse::builder).logger(LOG, "getRecipientInvitation").serviceDetails("RecipientInvitation", "GetRecipientInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/RecipientInvitation/GetRecipientInvitation").method(Method.GET).requestBuilder(GetRecipientInvitationRequest::builder).basePath("/20230401").appendPathParam("recipientInvitations").appendPathParam(request.getRecipientInvitationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecipientInvitation.class, GetRecipientInvitationResponse.Builder::recipientInvitation).handleResponseHeaderString("opc-request-id", GetRecipientInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRecipientInvitationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<IgnoreRecipientInvitationResponse> ignoreRecipientInvitation(IgnoreRecipientInvitationRequest request, AsyncHandler<IgnoreRecipientInvitationRequest, IgnoreRecipientInvitationResponse> handler) {
        Validate.notBlank((String)request.getRecipientInvitationId(), (String)"recipientInvitationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, IgnoreRecipientInvitationResponse::builder).logger(LOG, "ignoreRecipientInvitation").serviceDetails("RecipientInvitation", "IgnoreRecipientInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/RecipientInvitation/IgnoreRecipientInvitation").method(Method.POST).requestBuilder(IgnoreRecipientInvitationRequest::builder).basePath("/20230401").appendPathParam("recipientInvitations").appendPathParam(request.getRecipientInvitationId()).appendPathParam("actions").appendPathParam("ignore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecipientInvitation.class, IgnoreRecipientInvitationResponse.Builder::recipientInvitation).handleResponseHeaderString("opc-request-id", IgnoreRecipientInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", IgnoreRecipientInvitationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListRecipientInvitationsResponse> listRecipientInvitations(ListRecipientInvitationsRequest request, AsyncHandler<ListRecipientInvitationsRequest, ListRecipientInvitationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListRecipientInvitationsResponse::builder).logger(LOG, "listRecipientInvitations").serviceDetails("RecipientInvitation", "ListRecipientInvitations", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/RecipientInvitation/ListRecipientInvitations").method(Method.GET).requestBuilder(ListRecipientInvitationsRequest::builder).basePath("/20230401").appendPathParam("recipientInvitations").appendQueryParam("senderTenancyId", (Object)request.getSenderTenancyId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecipientInvitationCollection.class, ListRecipientInvitationsResponse.Builder::recipientInvitationCollection).handleResponseHeaderString("opc-next-page", ListRecipientInvitationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRecipientInvitationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRecipientInvitationResponse> updateRecipientInvitation(UpdateRecipientInvitationRequest request, AsyncHandler<UpdateRecipientInvitationRequest, UpdateRecipientInvitationResponse> handler) {
        Validate.notBlank((String)request.getRecipientInvitationId(), (String)"recipientInvitationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRecipientInvitationDetails(), "updateRecipientInvitationDetails is required");
        return this.clientCall(request, UpdateRecipientInvitationResponse::builder).logger(LOG, "updateRecipientInvitation").serviceDetails("RecipientInvitation", "UpdateRecipientInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20230401/RecipientInvitation/UpdateRecipientInvitation").method(Method.PUT).requestBuilder(UpdateRecipientInvitationRequest::builder).basePath("/20230401").appendPathParam("recipientInvitations").appendPathParam(request.getRecipientInvitationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecipientInvitation.class, UpdateRecipientInvitationResponse.Builder::recipientInvitation).handleResponseHeaderString("opc-request-id", UpdateRecipientInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateRecipientInvitationResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public RecipientInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RecipientInvitationAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RecipientInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RecipientInvitationAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RecipientInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RecipientInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RecipientInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RecipientInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RecipientInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RecipientInvitationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RecipientInvitationAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "tenantmanagercontrolplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"tenantmanagercontrolplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RecipientInvitationAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RecipientInvitationAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

