/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.Subscription;
import com.oracle.bmc.tenantmanagercontrolplane.model.AssignedSubscriptionLineItemSummary;
import com.oracle.bmc.tenantmanagercontrolplane.model.AssignedSubscriptionSummary;
import com.oracle.bmc.tenantmanagercontrolplane.model.AvailableRegionSummary;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionLineItemSummary;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionMappingSummary;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAssignedSubscriptionLineItemsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAssignedSubscriptionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAvailableRegionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionLineItemsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionMappingsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAssignedSubscriptionLineItemsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAssignedSubscriptionsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAvailableRegionsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionLineItemsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionMappingsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SubscriptionPaginators {
    private final Subscription client;

    public SubscriptionPaginators(Subscription client) {
        this.client = client;
    }

    public Iterable<ListAssignedSubscriptionLineItemsResponse> listAssignedSubscriptionLineItemsResponseIterator(final ListAssignedSubscriptionLineItemsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAssignedSubscriptionLineItemsRequest.Builder>(){

            @Override
            public ListAssignedSubscriptionLineItemsRequest.Builder get() {
                return ListAssignedSubscriptionLineItemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssignedSubscriptionLineItemsResponse, String>(){

            @Override
            public String apply(ListAssignedSubscriptionLineItemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssignedSubscriptionLineItemsRequest.Builder>, ListAssignedSubscriptionLineItemsRequest>(){

            @Override
            public ListAssignedSubscriptionLineItemsRequest apply(RequestBuilderAndToken<ListAssignedSubscriptionLineItemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssignedSubscriptionLineItemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssignedSubscriptionLineItemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssignedSubscriptionLineItemsRequest, ListAssignedSubscriptionLineItemsResponse>(){

            @Override
            public ListAssignedSubscriptionLineItemsResponse apply(ListAssignedSubscriptionLineItemsRequest request) {
                return SubscriptionPaginators.this.client.listAssignedSubscriptionLineItems(request);
            }
        });
    }

    public Iterable<AssignedSubscriptionLineItemSummary> listAssignedSubscriptionLineItemsRecordIterator(final ListAssignedSubscriptionLineItemsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAssignedSubscriptionLineItemsRequest.Builder>(){

            @Override
            public ListAssignedSubscriptionLineItemsRequest.Builder get() {
                return ListAssignedSubscriptionLineItemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssignedSubscriptionLineItemsResponse, String>(){

            @Override
            public String apply(ListAssignedSubscriptionLineItemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssignedSubscriptionLineItemsRequest.Builder>, ListAssignedSubscriptionLineItemsRequest>(){

            @Override
            public ListAssignedSubscriptionLineItemsRequest apply(RequestBuilderAndToken<ListAssignedSubscriptionLineItemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssignedSubscriptionLineItemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssignedSubscriptionLineItemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssignedSubscriptionLineItemsRequest, ListAssignedSubscriptionLineItemsResponse>(){

            @Override
            public ListAssignedSubscriptionLineItemsResponse apply(ListAssignedSubscriptionLineItemsRequest request) {
                return SubscriptionPaginators.this.client.listAssignedSubscriptionLineItems(request);
            }
        }, (Function)new Function<ListAssignedSubscriptionLineItemsResponse, List<AssignedSubscriptionLineItemSummary>>(){

            @Override
            public List<AssignedSubscriptionLineItemSummary> apply(ListAssignedSubscriptionLineItemsResponse response) {
                return response.getAssignedSubscriptionLineItemCollection().getItems();
            }
        });
    }

    public Iterable<ListAssignedSubscriptionsResponse> listAssignedSubscriptionsResponseIterator(final ListAssignedSubscriptionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAssignedSubscriptionsRequest.Builder>(){

            @Override
            public ListAssignedSubscriptionsRequest.Builder get() {
                return ListAssignedSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssignedSubscriptionsResponse, String>(){

            @Override
            public String apply(ListAssignedSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssignedSubscriptionsRequest.Builder>, ListAssignedSubscriptionsRequest>(){

            @Override
            public ListAssignedSubscriptionsRequest apply(RequestBuilderAndToken<ListAssignedSubscriptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssignedSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssignedSubscriptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssignedSubscriptionsRequest, ListAssignedSubscriptionsResponse>(){

            @Override
            public ListAssignedSubscriptionsResponse apply(ListAssignedSubscriptionsRequest request) {
                return SubscriptionPaginators.this.client.listAssignedSubscriptions(request);
            }
        });
    }

    public Iterable<AssignedSubscriptionSummary> listAssignedSubscriptionsRecordIterator(final ListAssignedSubscriptionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAssignedSubscriptionsRequest.Builder>(){

            @Override
            public ListAssignedSubscriptionsRequest.Builder get() {
                return ListAssignedSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssignedSubscriptionsResponse, String>(){

            @Override
            public String apply(ListAssignedSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssignedSubscriptionsRequest.Builder>, ListAssignedSubscriptionsRequest>(){

            @Override
            public ListAssignedSubscriptionsRequest apply(RequestBuilderAndToken<ListAssignedSubscriptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssignedSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssignedSubscriptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssignedSubscriptionsRequest, ListAssignedSubscriptionsResponse>(){

            @Override
            public ListAssignedSubscriptionsResponse apply(ListAssignedSubscriptionsRequest request) {
                return SubscriptionPaginators.this.client.listAssignedSubscriptions(request);
            }
        }, (Function)new Function<ListAssignedSubscriptionsResponse, List<AssignedSubscriptionSummary>>(){

            @Override
            public List<AssignedSubscriptionSummary> apply(ListAssignedSubscriptionsResponse response) {
                return response.getAssignedSubscriptionCollection().getItems();
            }
        });
    }

    public Iterable<ListAvailableRegionsResponse> listAvailableRegionsResponseIterator(final ListAvailableRegionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAvailableRegionsRequest.Builder>(){

            @Override
            public ListAvailableRegionsRequest.Builder get() {
                return ListAvailableRegionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAvailableRegionsResponse, String>(){

            @Override
            public String apply(ListAvailableRegionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAvailableRegionsRequest.Builder>, ListAvailableRegionsRequest>(){

            @Override
            public ListAvailableRegionsRequest apply(RequestBuilderAndToken<ListAvailableRegionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAvailableRegionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAvailableRegionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAvailableRegionsRequest, ListAvailableRegionsResponse>(){

            @Override
            public ListAvailableRegionsResponse apply(ListAvailableRegionsRequest request) {
                return SubscriptionPaginators.this.client.listAvailableRegions(request);
            }
        });
    }

    public Iterable<AvailableRegionSummary> listAvailableRegionsRecordIterator(final ListAvailableRegionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAvailableRegionsRequest.Builder>(){

            @Override
            public ListAvailableRegionsRequest.Builder get() {
                return ListAvailableRegionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAvailableRegionsResponse, String>(){

            @Override
            public String apply(ListAvailableRegionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAvailableRegionsRequest.Builder>, ListAvailableRegionsRequest>(){

            @Override
            public ListAvailableRegionsRequest apply(RequestBuilderAndToken<ListAvailableRegionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAvailableRegionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAvailableRegionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAvailableRegionsRequest, ListAvailableRegionsResponse>(){

            @Override
            public ListAvailableRegionsResponse apply(ListAvailableRegionsRequest request) {
                return SubscriptionPaginators.this.client.listAvailableRegions(request);
            }
        }, (Function)new Function<ListAvailableRegionsResponse, List<AvailableRegionSummary>>(){

            @Override
            public List<AvailableRegionSummary> apply(ListAvailableRegionsResponse response) {
                return response.getAvailableRegionCollection().getItems();
            }
        });
    }

    public Iterable<ListSubscriptionLineItemsResponse> listSubscriptionLineItemsResponseIterator(final ListSubscriptionLineItemsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSubscriptionLineItemsRequest.Builder>(){

            @Override
            public ListSubscriptionLineItemsRequest.Builder get() {
                return ListSubscriptionLineItemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionLineItemsResponse, String>(){

            @Override
            public String apply(ListSubscriptionLineItemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionLineItemsRequest.Builder>, ListSubscriptionLineItemsRequest>(){

            @Override
            public ListSubscriptionLineItemsRequest apply(RequestBuilderAndToken<ListSubscriptionLineItemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscriptionLineItemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionLineItemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscriptionLineItemsRequest, ListSubscriptionLineItemsResponse>(){

            @Override
            public ListSubscriptionLineItemsResponse apply(ListSubscriptionLineItemsRequest request) {
                return SubscriptionPaginators.this.client.listSubscriptionLineItems(request);
            }
        });
    }

    public Iterable<SubscriptionLineItemSummary> listSubscriptionLineItemsRecordIterator(final ListSubscriptionLineItemsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSubscriptionLineItemsRequest.Builder>(){

            @Override
            public ListSubscriptionLineItemsRequest.Builder get() {
                return ListSubscriptionLineItemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionLineItemsResponse, String>(){

            @Override
            public String apply(ListSubscriptionLineItemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionLineItemsRequest.Builder>, ListSubscriptionLineItemsRequest>(){

            @Override
            public ListSubscriptionLineItemsRequest apply(RequestBuilderAndToken<ListSubscriptionLineItemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscriptionLineItemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionLineItemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscriptionLineItemsRequest, ListSubscriptionLineItemsResponse>(){

            @Override
            public ListSubscriptionLineItemsResponse apply(ListSubscriptionLineItemsRequest request) {
                return SubscriptionPaginators.this.client.listSubscriptionLineItems(request);
            }
        }, (Function)new Function<ListSubscriptionLineItemsResponse, List<SubscriptionLineItemSummary>>(){

            @Override
            public List<SubscriptionLineItemSummary> apply(ListSubscriptionLineItemsResponse response) {
                return response.getSubscriptionLineItemCollection().getItems();
            }
        });
    }

    public Iterable<ListSubscriptionMappingsResponse> listSubscriptionMappingsResponseIterator(final ListSubscriptionMappingsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSubscriptionMappingsRequest.Builder>(){

            @Override
            public ListSubscriptionMappingsRequest.Builder get() {
                return ListSubscriptionMappingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionMappingsResponse, String>(){

            @Override
            public String apply(ListSubscriptionMappingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionMappingsRequest.Builder>, ListSubscriptionMappingsRequest>(){

            @Override
            public ListSubscriptionMappingsRequest apply(RequestBuilderAndToken<ListSubscriptionMappingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscriptionMappingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionMappingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscriptionMappingsRequest, ListSubscriptionMappingsResponse>(){

            @Override
            public ListSubscriptionMappingsResponse apply(ListSubscriptionMappingsRequest request) {
                return SubscriptionPaginators.this.client.listSubscriptionMappings(request);
            }
        });
    }

    public Iterable<SubscriptionMappingSummary> listSubscriptionMappingsRecordIterator(final ListSubscriptionMappingsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSubscriptionMappingsRequest.Builder>(){

            @Override
            public ListSubscriptionMappingsRequest.Builder get() {
                return ListSubscriptionMappingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionMappingsResponse, String>(){

            @Override
            public String apply(ListSubscriptionMappingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionMappingsRequest.Builder>, ListSubscriptionMappingsRequest>(){

            @Override
            public ListSubscriptionMappingsRequest apply(RequestBuilderAndToken<ListSubscriptionMappingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscriptionMappingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionMappingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscriptionMappingsRequest, ListSubscriptionMappingsResponse>(){

            @Override
            public ListSubscriptionMappingsResponse apply(ListSubscriptionMappingsRequest request) {
                return SubscriptionPaginators.this.client.listSubscriptionMappings(request);
            }
        }, (Function)new Function<ListSubscriptionMappingsResponse, List<SubscriptionMappingSummary>>(){

            @Override
            public List<SubscriptionMappingSummary> apply(ListSubscriptionMappingsResponse response) {
                return response.getSubscriptionMappingCollection().getItems();
            }
        });
    }

    public Iterable<ListSubscriptionsResponse> listSubscriptionsResponseIterator(final ListSubscriptionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSubscriptionsRequest.Builder>(){

            @Override
            public ListSubscriptionsRequest.Builder get() {
                return ListSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, String>(){

            @Override
            public String apply(ListSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionsRequest.Builder>, ListSubscriptionsRequest>(){

            @Override
            public ListSubscriptionsRequest apply(RequestBuilderAndToken<ListSubscriptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscriptionsRequest, ListSubscriptionsResponse>(){

            @Override
            public ListSubscriptionsResponse apply(ListSubscriptionsRequest request) {
                return SubscriptionPaginators.this.client.listSubscriptions(request);
            }
        });
    }

    public Iterable<SubscriptionSummary> listSubscriptionsRecordIterator(final ListSubscriptionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSubscriptionsRequest.Builder>(){

            @Override
            public ListSubscriptionsRequest.Builder get() {
                return ListSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, String>(){

            @Override
            public String apply(ListSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionsRequest.Builder>, ListSubscriptionsRequest>(){

            @Override
            public ListSubscriptionsRequest apply(RequestBuilderAndToken<ListSubscriptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscriptionsRequest, ListSubscriptionsResponse>(){

            @Override
            public ListSubscriptionsResponse apply(ListSubscriptionsRequest request) {
                return SubscriptionPaginators.this.client.listSubscriptions(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, List<SubscriptionSummary>>(){

            @Override
            public List<SubscriptionSummary> apply(ListSubscriptionsResponse response) {
                return response.getSubscriptionCollection().getItems();
            }
        });
    }
}

