/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.tenantmanagercontrolplane.model.ClassicSubscriptionLifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionSummary;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityVersion")
@JsonFilter(value="explicitlySetFilter")
public final class ClassicSubscriptionSummary
extends SubscriptionSummary {
    @JsonProperty(value="classicSubscriptionId")
    private final String classicSubscriptionId;
    @JsonProperty(value="isClassicSubscription")
    private final Boolean isClassicSubscription;
    @JsonProperty(value="paymentModel")
    private final String paymentModel;
    @JsonProperty(value="regionAssignment")
    private final String regionAssignment;
    @JsonProperty(value="lifecycleState")
    private final ClassicSubscriptionLifecycleState lifecycleState;
    @JsonProperty(value="startDate")
    private final Date startDate;
    @JsonProperty(value="endDate")
    private final Date endDate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ClassicSubscriptionSummary(String id, String compartmentId, String serviceName, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String classicSubscriptionId, Boolean isClassicSubscription, String paymentModel, String regionAssignment, ClassicSubscriptionLifecycleState lifecycleState, Date startDate, Date endDate) {
        super(id, compartmentId, serviceName, timeCreated, timeUpdated, freeformTags, definedTags);
        this.classicSubscriptionId = classicSubscriptionId;
        this.isClassicSubscription = isClassicSubscription;
        this.paymentModel = paymentModel;
        this.regionAssignment = regionAssignment;
        this.lifecycleState = lifecycleState;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public String getClassicSubscriptionId() {
        return this.classicSubscriptionId;
    }

    public Boolean getIsClassicSubscription() {
        return this.isClassicSubscription;
    }

    public String getPaymentModel() {
        return this.paymentModel;
    }

    public String getRegionAssignment() {
        return this.regionAssignment;
    }

    public ClassicSubscriptionLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassicSubscriptionSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", classicSubscriptionId=").append(String.valueOf(this.classicSubscriptionId));
        sb.append(", isClassicSubscription=").append(String.valueOf(this.isClassicSubscription));
        sb.append(", paymentModel=").append(String.valueOf(this.paymentModel));
        sb.append(", regionAssignment=").append(String.valueOf(this.regionAssignment));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", startDate=").append(String.valueOf(this.startDate));
        sb.append(", endDate=").append(String.valueOf(this.endDate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassicSubscriptionSummary)) {
            return false;
        }
        ClassicSubscriptionSummary other = (ClassicSubscriptionSummary)((Object)o);
        return Objects.equals(this.classicSubscriptionId, other.classicSubscriptionId) && Objects.equals(this.isClassicSubscription, other.isClassicSubscription) && Objects.equals(this.paymentModel, other.paymentModel) && Objects.equals(this.regionAssignment, other.regionAssignment) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.startDate, other.startDate) && Objects.equals(this.endDate, other.endDate) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.classicSubscriptionId == null ? 43 : this.classicSubscriptionId.hashCode());
        result = result * 59 + (this.isClassicSubscription == null ? 43 : this.isClassicSubscription.hashCode());
        result = result * 59 + (this.paymentModel == null ? 43 : this.paymentModel.hashCode());
        result = result * 59 + (this.regionAssignment == null ? 43 : this.regionAssignment.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.startDate == null ? 43 : this.startDate.hashCode());
        result = result * 59 + (this.endDate == null ? 43 : this.endDate.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="classicSubscriptionId")
        private String classicSubscriptionId;
        @JsonProperty(value="isClassicSubscription")
        private Boolean isClassicSubscription;
        @JsonProperty(value="paymentModel")
        private String paymentModel;
        @JsonProperty(value="regionAssignment")
        private String regionAssignment;
        @JsonProperty(value="lifecycleState")
        private ClassicSubscriptionLifecycleState lifecycleState;
        @JsonProperty(value="startDate")
        private Date startDate;
        @JsonProperty(value="endDate")
        private Date endDate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder classicSubscriptionId(String classicSubscriptionId) {
            this.classicSubscriptionId = classicSubscriptionId;
            this.__explicitlySet__.add("classicSubscriptionId");
            return this;
        }

        public Builder isClassicSubscription(Boolean isClassicSubscription) {
            this.isClassicSubscription = isClassicSubscription;
            this.__explicitlySet__.add("isClassicSubscription");
            return this;
        }

        public Builder paymentModel(String paymentModel) {
            this.paymentModel = paymentModel;
            this.__explicitlySet__.add("paymentModel");
            return this;
        }

        public Builder regionAssignment(String regionAssignment) {
            this.regionAssignment = regionAssignment;
            this.__explicitlySet__.add("regionAssignment");
            return this;
        }

        public Builder lifecycleState(ClassicSubscriptionLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            this.__explicitlySet__.add("startDate");
            return this;
        }

        public Builder endDate(Date endDate) {
            this.endDate = endDate;
            this.__explicitlySet__.add("endDate");
            return this;
        }

        public ClassicSubscriptionSummary build() {
            ClassicSubscriptionSummary model = new ClassicSubscriptionSummary(this.id, this.compartmentId, this.serviceName, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags, this.classicSubscriptionId, this.isClassicSubscription, this.paymentModel, this.regionAssignment, this.lifecycleState, this.startDate, this.endDate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClassicSubscriptionSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("classicSubscriptionId")) {
                this.classicSubscriptionId(model.getClassicSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("isClassicSubscription")) {
                this.isClassicSubscription(model.getIsClassicSubscription());
            }
            if (model.wasPropertyExplicitlySet("paymentModel")) {
                this.paymentModel(model.getPaymentModel());
            }
            if (model.wasPropertyExplicitlySet("regionAssignment")) {
                this.regionAssignment(model.getRegionAssignment());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("startDate")) {
                this.startDate(model.getStartDate());
            }
            if (model.wasPropertyExplicitlySet("endDate")) {
                this.endDate(model.getEndDate());
            }
            return this;
        }
    }
}

