/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum EntityVersion implements BmcEnum
{
    V1("V1"),
    V2("V2");

    private final String value;
    private static Map<String, EntityVersion> map;

    private EntityVersion(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static EntityVersion create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid EntityVersion: " + key);
    }

    static {
        map = new HashMap<String, EntityVersion>();
        for (EntityVersion v : EntityVersion.values()) {
            map.put(v.getValue(), v);
        }
    }
}

