/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.threatintelligence.ThreatintelAsync;
import com.oracle.bmc.threatintelligence.model.Indicator;
import com.oracle.bmc.threatintelligence.model.IndicatorCountCollection;
import com.oracle.bmc.threatintelligence.model.IndicatorSummaryCollection;
import com.oracle.bmc.threatintelligence.model.ThreatTypesCollection;
import com.oracle.bmc.threatintelligence.requests.GetIndicatorRequest;
import com.oracle.bmc.threatintelligence.requests.ListIndicatorCountsRequest;
import com.oracle.bmc.threatintelligence.requests.ListIndicatorsRequest;
import com.oracle.bmc.threatintelligence.requests.ListThreatTypesRequest;
import com.oracle.bmc.threatintelligence.requests.SummarizeIndicatorsRequest;
import com.oracle.bmc.threatintelligence.responses.GetIndicatorResponse;
import com.oracle.bmc.threatintelligence.responses.ListIndicatorCountsResponse;
import com.oracle.bmc.threatintelligence.responses.ListIndicatorsResponse;
import com.oracle.bmc.threatintelligence.responses.ListThreatTypesResponse;
import com.oracle.bmc.threatintelligence.responses.SummarizeIndicatorsResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreatintelAsyncClient
extends BaseAsyncClient
implements ThreatintelAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("THREATINTEL").serviceEndpointPrefix("").serviceEndpointTemplate("https://api-threatintel.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ThreatintelAsyncClient.class);

    ThreatintelAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetIndicatorResponse> getIndicator(GetIndicatorRequest request, AsyncHandler<GetIndicatorRequest, GetIndicatorResponse> handler) {
        Validate.notBlank((String)request.getIndicatorId(), (String)"indicatorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetIndicatorResponse::builder).logger(LOG, "getIndicator").serviceDetails("Threatintel", "GetIndicator", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/Indicator/GetIndicator").method(Method.GET).requestBuilder(GetIndicatorRequest::builder).basePath("/20220901").appendPathParam("indicators").appendPathParam(request.getIndicatorId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Indicator.class, GetIndicatorResponse.Builder::indicator).handleResponseHeaderString("opc-request-id", GetIndicatorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListIndicatorCountsResponse> listIndicatorCounts(ListIndicatorCountsRequest request, AsyncHandler<ListIndicatorCountsRequest, ListIndicatorCountsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListIndicatorCountsResponse::builder).logger(LOG, "listIndicatorCounts").serviceDetails("Threatintel", "ListIndicatorCounts", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/IndicatorCountCollection/ListIndicatorCounts").method(Method.GET).requestBuilder(ListIndicatorCountsRequest::builder).basePath("/20220901").appendPathParam("indicatorCounts").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IndicatorCountCollection.class, ListIndicatorCountsResponse.Builder::indicatorCountCollection).handleResponseHeaderString("opc-request-id", ListIndicatorCountsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListIndicatorsResponse> listIndicators(ListIndicatorsRequest request, AsyncHandler<ListIndicatorsRequest, ListIndicatorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListIndicatorsResponse::builder).logger(LOG, "listIndicators").serviceDetails("Threatintel", "ListIndicators", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/IndicatorSummaryCollection/ListIndicators").method(Method.GET).requestBuilder(ListIndicatorsRequest::builder).basePath("/20220901").appendPathParam("indicators").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("threatTypeName", request.getThreatTypeName(), CollectionFormatType.Multi).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("value", (Object)request.getValue()).appendQueryParam("confidenceGreaterThanOrEqualTo", (Object)request.getConfidenceGreaterThanOrEqualTo()).appendQueryParam("timeUpdatedGreaterThanOrEqualTo", (Object)request.getTimeUpdatedGreaterThanOrEqualTo()).appendQueryParam("timeUpdatedLessThan", (Object)request.getTimeUpdatedLessThan()).appendQueryParam("timeLastSeenGreaterThanOrEqualTo", (Object)request.getTimeLastSeenGreaterThanOrEqualTo()).appendQueryParam("timeLastSeenLessThan", (Object)request.getTimeLastSeenLessThan()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IndicatorSummaryCollection.class, ListIndicatorsResponse.Builder::indicatorSummaryCollection).handleResponseHeaderString("opc-request-id", ListIndicatorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIndicatorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListThreatTypesResponse> listThreatTypes(ListThreatTypesRequest request, AsyncHandler<ListThreatTypesRequest, ListThreatTypesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListThreatTypesResponse::builder).logger(LOG, "listThreatTypes").serviceDetails("Threatintel", "ListThreatTypes", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/ThreatTypesCollection/ListThreatTypes").method(Method.GET).requestBuilder(ListThreatTypesRequest::builder).basePath("/20220901").appendPathParam("threatTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ThreatTypesCollection.class, ListThreatTypesResponse.Builder::threatTypesCollection).handleResponseHeaderString("opc-request-id", ListThreatTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListThreatTypesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeIndicatorsResponse> summarizeIndicators(SummarizeIndicatorsRequest request, AsyncHandler<SummarizeIndicatorsRequest, SummarizeIndicatorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSummarizeIndicatorsDetails(), "summarizeIndicatorsDetails is required");
        return this.clientCall(request, SummarizeIndicatorsResponse::builder).logger(LOG, "summarizeIndicators").serviceDetails("Threatintel", "SummarizeIndicators", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/Indicator/SummarizeIndicators").method(Method.POST).requestBuilder(SummarizeIndicatorsRequest::builder).basePath("/20220901").appendPathParam("indicators").appendPathParam("actions").appendPathParam("summarize").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(IndicatorSummaryCollection.class, SummarizeIndicatorsResponse.Builder::indicatorSummaryCollection).handleResponseHeaderString("opc-request-id", SummarizeIndicatorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeIndicatorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Deprecated
    public ThreatintelAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ThreatintelAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ThreatintelAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ThreatintelAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ThreatintelAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ThreatintelAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ThreatintelAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ThreatintelAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ThreatintelAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ThreatintelAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ThreatintelAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ThreatintelAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ThreatintelAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ThreatintelAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ThreatintelAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "threatintelligence";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"threatintelligence");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ThreatintelAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ThreatintelAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

