/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataVisibility
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="tlpName")
    private final TlpName tlpName;

    @Deprecated
    @ConstructorProperties(value={"name", "tlpName"})
    public DataVisibility(String name, TlpName tlpName) {
        this.name = name;
        this.tlpName = tlpName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public TlpName getTlpName() {
        return this.tlpName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataVisibility(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", tlpName=").append(String.valueOf((Object)this.tlpName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataVisibility)) {
            return false;
        }
        DataVisibility other = (DataVisibility)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.tlpName, (Object)other.tlpName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.tlpName == null ? 43 : this.tlpName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TlpName implements BmcEnum
    {
        TlpInternalAudit("TLP_INTERNAL_AUDIT"),
        TlpWhite("TLP_WHITE"),
        TlpGreen("TLP_GREEN"),
        TlpAmber("TLP_AMBER"),
        TlpRed("TLP_RED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TlpName> map;

        private TlpName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TlpName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TlpName', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TlpName.class);
            map = new HashMap<String, TlpName>();
            for (TlpName v : TlpName.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="tlpName")
        private TlpName tlpName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder tlpName(TlpName tlpName) {
            this.tlpName = tlpName;
            this.__explicitlySet__.add("tlpName");
            return this;
        }

        public DataVisibility build() {
            DataVisibility model = new DataVisibility(this.name, this.tlpName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataVisibility model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("tlpName")) {
                this.tlpName(model.getTlpName());
            }
            return this;
        }
    }
}

