/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.threatintelligence.model.GeodataDetails;
import com.oracle.bmc.threatintelligence.model.IndicatorAttribute;
import com.oracle.bmc.threatintelligence.model.IndicatorRelationship;
import com.oracle.bmc.threatintelligence.model.IndicatorType;
import com.oracle.bmc.threatintelligence.model.LifecycleState;
import com.oracle.bmc.threatintelligence.model.ThreatType;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Indicator
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="type")
    private final IndicatorType type;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="confidence")
    private final Integer confidence;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="threatTypes")
    private final List<ThreatType> threatTypes;
    @JsonProperty(value="attributes")
    private final List<IndicatorAttribute> attributes;
    @JsonProperty(value="relationships")
    private final List<IndicatorRelationship> relationships;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;
    @JsonProperty(value="geodata")
    private final GeodataDetails geodata;

    @Deprecated
    @ConstructorProperties(value={"id", "type", "value", "confidence", "compartmentId", "threatTypes", "attributes", "relationships", "lifecycleState", "timeCreated", "timeUpdated", "timeLastSeen", "geodata"})
    public Indicator(String id, IndicatorType type, String value, Integer confidence, String compartmentId, List<ThreatType> threatTypes, List<IndicatorAttribute> attributes, List<IndicatorRelationship> relationships, LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, Date timeLastSeen, GeodataDetails geodata) {
        this.id = id;
        this.type = type;
        this.value = value;
        this.confidence = confidence;
        this.compartmentId = compartmentId;
        this.threatTypes = threatTypes;
        this.attributes = attributes;
        this.relationships = relationships;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.timeLastSeen = timeLastSeen;
        this.geodata = geodata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public IndicatorType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getConfidence() {
        return this.confidence;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<ThreatType> getThreatTypes() {
        return this.threatTypes;
    }

    public List<IndicatorAttribute> getAttributes() {
        return this.attributes;
    }

    public List<IndicatorRelationship> getRelationships() {
        return this.relationships;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public GeodataDetails getGeodata() {
        return this.geodata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Indicator(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", confidence=").append(String.valueOf(this.confidence));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", threatTypes=").append(String.valueOf(this.threatTypes));
        sb.append(", attributes=").append(String.valueOf(this.attributes));
        sb.append(", relationships=").append(String.valueOf(this.relationships));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(", geodata=").append(String.valueOf((Object)this.geodata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Indicator)) {
            return false;
        }
        Indicator other = (Indicator)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.confidence, other.confidence) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.threatTypes, other.threatTypes) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.relationships, other.relationships) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && Objects.equals((Object)this.geodata, (Object)other.geodata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.confidence == null ? 43 : this.confidence.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.threatTypes == null ? 43 : this.threatTypes.hashCode());
        result = result * 59 + (this.attributes == null ? 43 : this.attributes.hashCode());
        result = result * 59 + (this.relationships == null ? 43 : this.relationships.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + (this.geodata == null ? 43 : this.geodata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="type")
        private IndicatorType type;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="confidence")
        private Integer confidence;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="threatTypes")
        private List<ThreatType> threatTypes;
        @JsonProperty(value="attributes")
        private List<IndicatorAttribute> attributes;
        @JsonProperty(value="relationships")
        private List<IndicatorRelationship> relationships;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonProperty(value="geodata")
        private GeodataDetails geodata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder type(IndicatorType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.__explicitlySet__.add("confidence");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder threatTypes(List<ThreatType> threatTypes) {
            this.threatTypes = threatTypes;
            this.__explicitlySet__.add("threatTypes");
            return this;
        }

        public Builder attributes(List<IndicatorAttribute> attributes) {
            this.attributes = attributes;
            this.__explicitlySet__.add("attributes");
            return this;
        }

        public Builder relationships(List<IndicatorRelationship> relationships) {
            this.relationships = relationships;
            this.__explicitlySet__.add("relationships");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public Builder geodata(GeodataDetails geodata) {
            this.geodata = geodata;
            this.__explicitlySet__.add("geodata");
            return this;
        }

        public Indicator build() {
            Indicator model = new Indicator(this.id, this.type, this.value, this.confidence, this.compartmentId, this.threatTypes, this.attributes, this.relationships, this.lifecycleState, this.timeCreated, this.timeUpdated, this.timeLastSeen, this.geodata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Indicator model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("confidence")) {
                this.confidence(model.getConfidence());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("threatTypes")) {
                this.threatTypes(model.getThreatTypes());
            }
            if (model.wasPropertyExplicitlySet("attributes")) {
                this.attributes(model.getAttributes());
            }
            if (model.wasPropertyExplicitlySet("relationships")) {
                this.relationships(model.getRelationships());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            if (model.wasPropertyExplicitlySet("geodata")) {
                this.geodata(model.getGeodata());
            }
            return this;
        }
    }
}

